/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint.label;

import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.document.format.TextLabelFormats;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintUtils;
import info.bioinfweb.treegraph.graphics.positionpaint.label.AbstractLabelPainter;
import info.bioinfweb.treegraph.graphics.positionpaint.positiondata.PositionData;
import java.awt.Graphics2D;

public class TextLabelPainter
extends AbstractLabelPainter<TextLabel, PositionData> {
    @Override
    protected void doCalculatePositionData(TextLabel label, PositionData pd) {
        DistanceDimension dimension = PositionPaintUtils.calculateTextDimension(label);
        pd.getWidth().assign(dimension.getWidth());
        pd.getHeight().assign(dimension.getHeight());
    }

    @Override
    protected void doPaint(Graphics2D g, float pixelsPerMillimeter, PositionData positionData, TextLabel label) {
        TextLabelFormats f = label.getFormats();
        PositionPaintUtils.paintText(g, pixelsPerMillimeter, label.getData().formatValue(f.getDecimalFormat()), f, positionData.getLeft().getInPixels(pixelsPerMillimeter), positionData.getTop().getInPixels(pixelsPerMillimeter) + (float)g.getFontMetrics(f.getFont(pixelsPerMillimeter)).getAscent());
    }

    @Override
    public Class<TextLabel> getLabelClass() {
        return TextLabel.class;
    }

    @Override
    public Class<PositionData> getPositionDataClass() {
        return PositionData.class;
    }
}

