/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint.label;

import info.bioinfweb.commons.graphics.FontCalculator;
import info.bioinfweb.treegraph.document.PieChartLabel;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.document.format.PieChartLabelCaptionContentType;
import info.bioinfweb.treegraph.document.format.PieChartLabelCaptionLinkType;
import info.bioinfweb.treegraph.document.format.PieChartLabelFormats;
import info.bioinfweb.treegraph.document.format.TextFormats;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintUtils;
import info.bioinfweb.treegraph.graphics.positionpaint.label.AbstractGraphicalLabelPainter;
import info.bioinfweb.treegraph.graphics.positionpaint.positiondata.PieChartLabelPositionData;
import info.bioinfweb.treegraph.graphics.positionpaint.positiondata.PositionData;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PieChartLabelPainter
extends AbstractGraphicalLabelPainter<PieChartLabel, PieChartLabelPositionData> {
    public static final float LINE_START_DISTANCE_FACTOR = 0.9f;
    public static final float MINIMAL_CENTER_DISTANCE_FACTOR = 0.2f;
    public static final float RELATIVE_CAPTION_LINE_DISTANCE = 0.3f;
    public static final float CAPTION_DISTANCE_FACTOR = 0.3f;

    private static double editAngle(double angle) {
        if ((angle += 90.0) < 360.0) {
            angle -= 360.0;
        }
        return angle;
    }

    private List<Point2D.Float> calculateStartPoints(PieChartLabel label, PieChartLabelPositionData positionData) {
        ArrayList<Point2D.Float> result = new ArrayList<Point2D.Float>(label.getSectionDataList().size());
        PieChartLabelFormats f = label.getFormats();
        float centerX = 0.5f * f.getWidth().getInMillimeters();
        float centerY = 0.5f * f.getHeight().getInMillimeters();
        float halfLineWidth = 0.5f * f.getLineWidth().getInMillimeters();
        float rX = Math.max(0.2f * centerX, 0.9f * centerX - halfLineWidth);
        float rY = Math.max(0.2f * centerY, 0.9f * centerY - halfLineWidth);
        double[] angles = label.getPieChartAngles();
        double startAngle = 0.0;
        int i = 0;
        while (i < angles.length) {
            double angle = Math.toRadians(PieChartLabelPainter.editAngle(startAngle + 0.5 * angles[i]));
            startAngle += angles[i];
            result.add(new Point2D.Float((float)((double)centerX + (double)rX * Math.cos(angle)), (float)((double)centerY - (double)rY * Math.sin(angle))));
            ++i;
        }
        return result;
    }

    private void createOrderedCaptionPositions(PieChartLabelPositionData positionData, List<Point2D.Float> startPoints) {
        int i = 0;
        while (i < startPoints.size()) {
            PieChartLabelPositionData.CaptionPositionData data = new PieChartLabelPositionData.CaptionPositionData(i);
            Point2D.Float point = startPoints.get(i);
            data.getLineStartX().setInMillimeters(point.x);
            data.getLineStartY().setInMillimeters(point.y);
            positionData.getCaptionPositions().add(data);
            ++i;
        }
        Collections.sort(positionData.getCaptionPositions(), new Comparator<PieChartLabelPositionData.CaptionPositionData>(){

            @Override
            public int compare(PieChartLabelPositionData.CaptionPositionData o1, PieChartLabelPositionData.CaptionPositionData o2) {
                return Math.round(Math.signum(o1.getLineStartY().getInMillimeters() - o2.getLineStartY().getInMillimeters()));
            }
        });
        float previousDistance = Float.POSITIVE_INFINITY;
        int i2 = 0;
        while (i2 < positionData.getCaptionPositions().size() - 1) {
            PieChartLabelPositionData.CaptionPositionData current = positionData.getCaptionPositions().get(i2);
            PieChartLabelPositionData.CaptionPositionData next = positionData.getCaptionPositions().get(i2 + 1);
            boolean left = i2 % 2 == 0;
            float currentDistanceY = next.getLineStartY().getInMillimeters() - current.getLineStartY().getInMillimeters();
            float nextDistanceY = Float.POSITIVE_INFINITY;
            if (i2 + 2 < positionData.getCaptionPositions().size()) {
                nextDistanceY = positionData.getCaptionPositions().get(i2 + 2).getLineStartY().getInMillimeters() - next.getLineStartY().getInMillimeters();
            }
            if (currentDistanceY <= nextDistanceY && currentDistanceY <= previousDistance && (left && current.getLineStartX().getInMillimeters() > next.getLineStartX().getInMillimeters() || !left && current.getLineStartX().getInMillimeters() < next.getLineStartX().getInMillimeters())) {
                positionData.getCaptionPositions().set(i2, next);
                positionData.getCaptionPositions().set(i2 + 1, current);
                ++i2;
            }
            previousDistance = currentDistanceY;
            ++i2;
        }
    }

    @Override
    protected void doCalculatePositionData(PieChartLabel label, PieChartLabelPositionData positionData) {
        PieChartLabelFormats f = label.getFormats();
        positionData.getCaptionPositions().clear();
        PositionData titlePosition = positionData.getTitlePosition();
        titlePosition.getTop().setInMillimeters(0.0f);
        if (f.isShowTitle()) {
            DistanceDimension dim = PositionPaintUtils.calculateTextDimension(label);
            titlePosition.getWidth().assign(dim.getWidth());
            titlePosition.getHeight().assign(dim.getHeight());
        } else {
            titlePosition.getWidth().setInMillimeters(0.0f);
            titlePosition.getHeight().setInMillimeters(0.0f);
        }
        float chartAndCaptionsY = 1.3f * positionData.getTitlePosition().getHeight().getInMillimeters();
        positionData.getChartPosition().getWidth().assign(f.getWidth());
        positionData.getChartPosition().getHeight().assign(f.getHeight());
        if (PieChartLabelCaptionContentType.NONE.equals((Object)f.getCaptionsContentType()) || label.getSectionDataList().isEmpty()) {
            float halfWidthDifference = 0.5f * (titlePosition.getWidth().getInMillimeters() - f.getWidth().getInMillimeters());
            if (halfWidthDifference > 0.0f) {
                positionData.getChartPosition().getLeft().setInMillimeters(halfWidthDifference);
                titlePosition.getLeft().setInMillimeters(0.0f);
            } else {
                positionData.getChartPosition().getLeft().setInMillimeters(0.0f);
                titlePosition.getLeft().setInMillimeters(-halfWidthDifference);
            }
            positionData.getChartPosition().getTop().setInMillimeters(chartAndCaptionsY);
            positionData.getWidth().setInMillimeters(Math.max(f.getWidth().getInMillimeters(), titlePosition.getWidth().getInMillimeters()));
            positionData.getHeight().setInMillimeters(chartAndCaptionsY + f.getHeight().getInMillimeters());
        } else {
            int captionColumnCount = label.getSectionDataList().size() > 1 ? 2 : 1;
            TextFormats captionFormats = f.getCaptionsTextFormats();
            int captionsPerSide = label.getSectionDataList().size() / 2 + label.getSectionDataList().size() % 2;
            float captionHeight = f.getHeight().getInMillimeters() / ((float)captionsPerSide + (float)(captionsPerSide - 1) * 0.3f);
            f.getCaptionsTextFormats().getTextHeight().setInMillimeters(captionHeight);
            float captionLineHeight = 1.3f * captionHeight;
            float captionDistance = 0.3f * captionHeight;
            float captionChartSpace = f.getCaptionsLinkType().equals((Object)PieChartLabelCaptionLinkType.COLORED_BOXES) ? captionHeight + captionDistance : captionDistance;
            this.createOrderedCaptionPositions(positionData, this.calculateStartPoints(label, positionData));
            float leftColumnWidth = 0.0f;
            float rightColumnWidth = 0.0f;
            int i = 0;
            while (i < positionData.getCaptionPositions().size()) {
                PieChartLabelPositionData.CaptionPositionData data = positionData.getCaptionPositions().get(i);
                float width = FontCalculator.getInstance().getTextWidthToTextHeigth(captionFormats.getFontName(), captionFormats.getTextStyle(), label.getCaptionText(data.getCaptionIndex()), captionHeight);
                if (i % 2 == 0) {
                    leftColumnWidth = Math.max(leftColumnWidth, width);
                } else {
                    rightColumnWidth = Math.max(rightColumnWidth, width);
                }
                data.getWidth().setInMillimeters(width);
                ++i;
            }
            float leftColumnX = 0.0f;
            float rightColumnX = leftColumnWidth + f.getWidth().getInMillimeters() + (float)captionColumnCount * (captionChartSpace + captionDistance);
            float chartAndCaptionsWidth = rightColumnX + rightColumnWidth;
            float halfWidthDifference = 0.5f * (titlePosition.getWidth().getInMillimeters() - chartAndCaptionsWidth);
            if (halfWidthDifference > 0.0f) {
                leftColumnX = halfWidthDifference;
                rightColumnX += halfWidthDifference;
                titlePosition.getLeft().setInMillimeters(0.0f);
            } else {
                titlePosition.getLeft().setInMillimeters(-halfWidthDifference);
            }
            positionData.getChartPosition().getLeft().setInMillimeters(leftColumnX + leftColumnWidth + captionChartSpace + captionDistance);
            positionData.getChartPosition().getTop().setInMillimeters(chartAndCaptionsY);
            positionData.getWidth().setInMillimeters(Math.max(chartAndCaptionsWidth, titlePosition.getWidth().getInMillimeters()));
            positionData.getHeight().setInMillimeters(chartAndCaptionsY + f.getHeight().getInMillimeters());
            float yLeft = chartAndCaptionsY;
            float yRight = chartAndCaptionsY;
            if (label.getSectionDataList().size() % 2 != 0) {
                yRight += 0.5f * captionLineHeight;
            }
            int i2 = 0;
            while (i2 < positionData.getCaptionPositions().size()) {
                PieChartLabelPositionData.CaptionPositionData data = positionData.getCaptionPositions().get(i2);
                if (i2 % 2 == 0) {
                    data.getLeft().setInMillimeters(leftColumnX + leftColumnWidth - data.getWidth().getInMillimeters());
                    data.getTop().setInMillimeters(yLeft);
                    yLeft += captionLineHeight;
                } else {
                    data.getLeft().setInMillimeters(rightColumnX);
                    data.getTop().setInMillimeters(yRight);
                    yRight += captionLineHeight;
                }
                data.getHeight().setInMillimeters(captionHeight);
                ++i2;
            }
        }
    }

    private boolean twoSectorsNotZero(double[] angles) {
        int count = 0;
        int i = 0;
        while (i < angles.length) {
            if (!Double.isNaN(angles[i]) && angles[i] > 0.0 && ++count == 2) {
                return true;
            }
            ++i;
        }
        return count >= 2;
    }

    private void paintPieChart(Graphics2D g, float pixelsPerMillimeter, float x, float y, float width, float height, PieChartLabel label) {
        PieChartLabel l = label;
        double[] angles = l.getPieChartAngles();
        double startAngle = 0.0;
        boolean twoValid = this.twoSectorsNotZero(angles);
        PieChartLabelFormats f = l.getFormats();
        Arc2D.Double[] arcs = new Arc2D.Double[angles.length];
        int j = 0;
        while (j < angles.length) {
            if (f.isShowLinesForZero() || !Double.isNaN(angles[j]) && angles[j] > 0.0) {
                arcs[j] = new Arc2D.Double(x, y, width, height, Math.round(PieChartLabelPainter.editAngle(startAngle)), Math.round(angles[j]), 2);
                g.setColor(f.getPieColor(j));
                g.fill(arcs[j]);
                startAngle += angles[j];
            }
            ++j;
        }
        g.setColor(f.getLineColor());
        if (f.isShowInternalLines() && (twoValid || f.isShowLinesForZero())) {
            startAngle = 0.0;
            j = 0;
            while (j < arcs.length) {
                if (f.isShowLinesForZero() || !Double.isNaN(angles[j]) && angles[j] > 0.0) {
                    g.draw(arcs[j]);
                    startAngle += angles[j];
                }
                ++j;
            }
        }
        g.draw(new Ellipse2D.Float(x, y, width, height));
    }

    private void paintCaptions(Graphics2D g, float pixelsPerMillimeter, PieChartLabelPositionData positionData, PieChartLabel label) {
        if (!positionData.getCaptionPositions().isEmpty()) {
            PieChartLabelFormats f = label.getFormats();
            float edgeLength = positionData.getCaptionPositions().get(0).getHeight().getInPixels(pixelsPerMillimeter);
            float captionDistance = 0.3f * edgeLength;
            float halfCaptionDistance = 0.5f * captionDistance;
            float xLeft = positionData.getLeft().getInPixels(pixelsPerMillimeter) + positionData.getChartPosition().getLeft().getInPixels(pixelsPerMillimeter) - edgeLength - captionDistance;
            float xRight = positionData.getLeft().getInPixels(pixelsPerMillimeter) + positionData.getChartPosition().getRightInPixels(pixelsPerMillimeter) + captionDistance;
            float halfLineWidth = 0.5f * f.getLineWidth().getInPixels(pixelsPerMillimeter);
            edgeLength -= 2.0f * halfLineWidth;
            float lineOffsetX = positionData.getLeft().getInPixels(pixelsPerMillimeter) + positionData.getChartPosition().getLeft().getInPixels(pixelsPerMillimeter);
            float lineOffsetY = positionData.getTop().getInPixels(pixelsPerMillimeter) + positionData.getChartPosition().getTop().getInPixels(pixelsPerMillimeter);
            float leftLineEndX = lineOffsetX - captionDistance;
            float rightLineEndX = positionData.getLeft().getInPixels(pixelsPerMillimeter) + positionData.getChartPosition().getRightInPixels(pixelsPerMillimeter) + captionDistance;
            if (!f.getCaptionsContentType().equals((Object)PieChartLabelCaptionContentType.NONE)) {
                int i = 0;
                while (i < positionData.getCaptionPositions().size()) {
                    boolean left = i % 2 == 0;
                    PieChartLabelPositionData.CaptionPositionData captionPosition = positionData.getCaptionPositions().get(i);
                    PositionPaintUtils.paintText(g, pixelsPerMillimeter, label.getCaptionText(captionPosition.getCaptionIndex()), f.getCaptionsTextFormats(), positionData.getLeft().getInPixels(pixelsPerMillimeter) + captionPosition.getLeft().getInPixels(pixelsPerMillimeter), positionData.getTop().getInPixels(pixelsPerMillimeter) + captionPosition.getTop().getInPixels(pixelsPerMillimeter) + (float)g.getFontMetrics(f.getCaptionsTextFormats().getFont(pixelsPerMillimeter)).getAscent());
                    switch (f.getCaptionsLinkType()) {
                        case COLORED_BOXES: {
                            Rectangle2D.Float r = new Rectangle2D.Float((left ? xLeft : xRight) + halfLineWidth, positionData.getTop().getInPixels(pixelsPerMillimeter) + captionPosition.getTop().getInPixels(pixelsPerMillimeter) + halfLineWidth, edgeLength, edgeLength);
                            g.setColor(f.getPieColor(captionPosition.getCaptionIndex()));
                            g.fill(r);
                            g.setColor(f.getLineColor());
                            g.draw(r);
                            break;
                        }
                        case STRAIGHT_LINES: 
                        case HORIZONTAL_LINES: {
                            g.setColor(f.getLineColor());
                            float startY = lineOffsetY + captionPosition.getLineStartY().getInPixels(pixelsPerMillimeter);
                            Path2D.Float path = new Path2D.Float();
                            path.moveTo(lineOffsetX + captionPosition.getLineStartX().getInPixels(pixelsPerMillimeter), startY);
                            if (f.getCaptionsLinkType().equals((Object)PieChartLabelCaptionLinkType.HORIZONTAL_LINES)) {
                                path.lineTo(left ? leftLineEndX + halfCaptionDistance : rightLineEndX - halfCaptionDistance, startY);
                            }
                            path.lineTo(left ? leftLineEndX : rightLineEndX, positionData.getTop().getInPixels(pixelsPerMillimeter) + captionPosition.getCenterYInPixels(pixelsPerMillimeter));
                            g.draw(path);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    protected void doPaint(Graphics2D g, float pixelsPerMillimeter, PieChartLabelPositionData positionData, PieChartLabel label) {
        Stroke stroke = g.getStroke();
        try {
            g.setStroke(new BasicStroke(label.getFormats().getLineWidth().getInPixels(pixelsPerMillimeter)));
            if (label.getFormats().isShowTitle()) {
                PositionData titlePosition = positionData.getTitlePosition();
                PositionPaintUtils.paintText(g, pixelsPerMillimeter, label.getData().formatValue(label.getFormats().getDecimalFormat()), label.getFormats(), positionData.getLeft().getInPixels(pixelsPerMillimeter) + titlePosition.getLeft().getInPixels(pixelsPerMillimeter), positionData.getTop().getInPixels(pixelsPerMillimeter) + titlePosition.getTop().getInPixels(pixelsPerMillimeter) + (float)g.getFontMetrics(label.getFormats().getFont(pixelsPerMillimeter)).getAscent());
            }
            float lineWidth = label.getFormats().getLineWidth().getInPixels(pixelsPerMillimeter);
            float halfLineWidth = 0.5f * lineWidth;
            this.paintPieChart(g, pixelsPerMillimeter, positionData.getLeft().getInPixels(pixelsPerMillimeter) + positionData.getChartPosition().getLeft().getInPixels(pixelsPerMillimeter) + halfLineWidth, positionData.getTop().getInPixels(pixelsPerMillimeter) + positionData.getChartPosition().getTop().getInPixels(pixelsPerMillimeter) + halfLineWidth, positionData.getChartPosition().getWidth().getInPixels(pixelsPerMillimeter) - lineWidth, positionData.getChartPosition().getHeight().getInPixels(pixelsPerMillimeter) - lineWidth, label);
            this.paintCaptions(g, pixelsPerMillimeter, positionData, label);
        }
        finally {
            g.setStroke(stroke);
        }
    }

    @Override
    public Class<PieChartLabel> getLabelClass() {
        return PieChartLabel.class;
    }

    @Override
    public Class<PieChartLabelPositionData> getPositionDataClass() {
        return PieChartLabelPositionData.class;
    }
}

