/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint.label;

import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.graphics.positionpaint.label.IconLabelPainter;
import info.bioinfweb.treegraph.graphics.positionpaint.label.LabelPainter;
import info.bioinfweb.treegraph.graphics.positionpaint.label.PieChartLabelPainter;
import info.bioinfweb.treegraph.graphics.positionpaint.label.TextLabelPainter;
import java.util.HashMap;
import java.util.Map;

public class LabelPainterMap {
    private static LabelPainterMap firstInstance = null;
    private Map<Class<? extends Label>, LabelPainter<?, ?>> map = new HashMap();

    public static LabelPainterMap getInstance() {
        if (firstInstance == null) {
            firstInstance = new LabelPainterMap();
        }
        return firstInstance;
    }

    private LabelPainterMap() {
        this.fillMap();
    }

    private void fillMap() {
        this.put(new TextLabelPainter());
        this.put(new IconLabelPainter());
        this.put(new PieChartLabelPainter());
    }

    private void put(LabelPainter<?, ?> painter) {
        this.map.put(painter.getLabelClass(), painter);
    }

    public <L extends Label> LabelPainter<L, ?> getLabelPainter(Class<L> labelClass) {
        return this.map.get(labelClass);
    }

    public <L extends Label> LabelPainter<L, ?> getLabelPainter(L label) {
        return this.getLabelPainter((L)((Object)label.getClass()));
    }
}

