/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.AbstractPaintableElement;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Legends;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.ScaleBar;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.document.format.GlobalFormats;
import info.bioinfweb.treegraph.document.format.LegendFormats;
import info.bioinfweb.treegraph.document.format.LegendStyle;
import info.bioinfweb.treegraph.document.format.Margin;
import info.bioinfweb.treegraph.document.format.ScaleBarFormats;
import info.bioinfweb.treegraph.document.format.TextOrientation;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintType;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintUtils;
import info.bioinfweb.treegraph.graphics.positionpaint.TreePositioner;
import info.bioinfweb.treegraph.graphics.positionpaint.label.LabelPainter;
import info.bioinfweb.treegraph.graphics.positionpaint.label.LabelPainterMap;
import info.bioinfweb.treegraph.graphics.positionpaint.positiondata.LegendPositionData;
import info.bioinfweb.treegraph.graphics.positionpaint.positiondata.NodePositionData;
import info.bioinfweb.treegraph.graphics.positionpaint.positiondata.PositionData;

public class RectangularCladogramPositioner
implements TreePositioner {
    private static RectangularCladogramPositioner firstInstance = null;
    protected PositionPaintType type = PositionPaintFactory.getInstance().getType(this);
    protected Document document;
    private float maxLeafWidth = 0.0f;
    protected float rescalingFactorX = 1.0f;

    protected RectangularCladogramPositioner() {
    }

    public static RectangularCladogramPositioner getInstance() {
        if (firstInstance == null) {
            firstInstance = new RectangularCladogramPositioner();
        }
        return firstInstance;
    }

    private DistanceDimension calculateTaxonDimension(Node terminal) {
        DistanceDimension result = PositionPaintUtils.calculateTextDimension(terminal);
        Margin m = terminal.getFormats().getLeafMargin();
        result.getWidth().add(m.getLeft());
        result.getWidth().add(m.getRight());
        result.getHeight().add(m.getTop());
        result.getHeight().add(m.getBottom());
        return result;
    }

    private void calculateLabelBlockDimensions(Labels labels, boolean above) {
        int lineNo = 0;
        while (lineNo < labels.lineCount(above)) {
            int pos = 0;
            while (pos < labels.labelCount(above, lineNo)) {
                Label l = labels.get(above, lineNo, pos);
                PositionData pd = l.getPosition(this.type);
                LabelPainter<Label, ?> painter = LabelPainterMap.getInstance().getLabelPainter(l);
                if (painter == null) {
                    throw new InternalError("Unsupported label of type " + l.getClass().getCanonicalName() + " found.");
                }
                painter.calculatePositionData(l, pd);
                ++pos;
            }
            ++lineNo;
        }
    }

    private float labelLineHeight(Labels labels, boolean above, int lineNo) {
        float result = 0.0f;
        int lineIndex = 0;
        while (lineIndex < labels.labelCount(above, lineNo)) {
            Label l = labels.get(above, lineNo, lineIndex);
            Margin m = l.getFormats().getMargin();
            result = Math.max(result, m.getTop().getInMillimeters() + m.getBottom().getInMillimeters() + l.getPosition(this.type).getHeight().getInMillimeters());
            ++lineIndex;
        }
        return result;
    }

    private float labelBlockHeight(Labels labels, boolean above) {
        float result = 0.0f;
        int lineNo = 0;
        while (lineNo < labels.lineCount(above)) {
            result += this.labelLineHeight(labels, above, lineNo);
            ++lineNo;
        }
        return result;
    }

    private float labelLineWidth(Labels labels, boolean above, int lineNo) {
        float result = 0.0f;
        int lineIndex = 0;
        while (lineIndex < labels.labelCount(above, lineNo)) {
            Label l = labels.get(above, lineNo, lineIndex);
            Margin m = l.getFormats().getMargin();
            result += l.getPosition(this.type).getWidth().getInMillimeters() + m.getLeft().getInMillimeters() + m.getRight().getInMillimeters();
            ++lineIndex;
        }
        return result;
    }

    protected float labelBlockWidth(Labels labels) {
        float result = 0.0f;
        int lineNo = 0;
        while (lineNo < labels.lineCount(true)) {
            result = Math.max(result, this.labelLineWidth(labels, true, lineNo));
            ++lineNo;
        }
        lineNo = 0;
        while (lineNo < labels.lineCount(false)) {
            result = Math.max(result, this.labelLineWidth(labels, false, lineNo));
            ++lineNo;
        }
        return result;
    }

    private float calculateWidthsHeights(Node root) {
        float result = 0.0f;
        NodePositionData pd = root.getPosition(this.type);
        pd.setHeightAbove(0.0f);
        pd.setHeightBelow(0.0f);
        float branchHeight = 0.0f;
        if (root.hasAfferentBranch()) {
            branchHeight = root.getAfferentBranch().getFormats().getLineWidth().getInMillimeters();
            if (root.hasParent()) {
                branchHeight = Math.max(branchHeight, root.getParent().getFormats().getLineWidth().getInMillimeters());
            }
            root.getAfferentBranch().getPosition(this.type).getHeight().setInMillimeters(branchHeight);
            this.calculateLabelBlockDimensions(root.getAfferentBranch().getLabels(), true);
            pd.setHeightAbove(this.labelBlockHeight(root.getAfferentBranch().getLabels(), true) + root.getAfferentBranch().getFormats().getMinSpaceAbove().getInMillimeters() + 0.5f * branchHeight);
            this.calculateLabelBlockDimensions(root.getAfferentBranch().getLabels(), false);
            pd.setHeightBelow(this.labelBlockHeight(root.getAfferentBranch().getLabels(), false) + root.getAfferentBranch().getFormats().getMinSpaceBelow().getInMillimeters() + 0.5f * branchHeight);
        }
        DistanceDimension d = this.calculateTaxonDimension(root);
        if (root.getChildren().size() > 0) {
            result = Math.max(result, this.calculateWidthsHeights(root.getChildren().get(0)));
            Node subnode = root.getChildren().get(0);
            pd.setDifAbove(subnode.getPosition(this.type).getHeightAbove());
            if (root.getChildren().size() > 1) {
                pd.getHeight().setInMillimeters(subnode.getPosition(this.type).getHeightBelow());
                int i = 1;
                while (i <= root.getChildren().size() - 2) {
                    subnode = root.getChildren().get(i);
                    result = Math.max(result, this.calculateWidthsHeights(subnode));
                    pd.getHeight().add(subnode.getPosition(this.type).getHeightAbove() + root.getChildren().get(i).getPosition(this.type).getHeightBelow());
                    ++i;
                }
                subnode = root.getChildren().get(root.getChildren().size() - 1);
                result = Math.max(result, this.calculateWidthsHeights(subnode));
                pd.getHeight().add(subnode.getPosition(this.type).getHeightAbove());
            } else {
                pd.getHeight().setInMillimeters(root.getFormats().getLineWidth().getInMillimeters());
            }
            pd.setDifBelow(subnode.getPosition(this.type).getHeightBelow());
        } else {
            pd.getHeight().assign(d.getHeight());
            pd.setDifAbove(0.0f);
            pd.setDifBelow(0.0f);
        }
        float halfHeight = 0.5f * pd.getHeight().getInMillimeters() + pd.getDifAbove();
        if (pd.getHeightAbove() > halfHeight) {
            pd.setDifAbove(pd.getHeightAbove() - 0.5f * pd.getHeight().getInMillimeters());
        } else {
            pd.setHeightAbove(halfHeight);
        }
        halfHeight = 0.5f * pd.getHeight().getInMillimeters() + pd.getDifBelow();
        if (pd.getHeightBelow() > halfHeight) {
            pd.setDifBelow(pd.getHeightBelow() - 0.5f * pd.getHeight().getInMillimeters());
        } else {
            pd.setHeightBelow(halfHeight);
        }
        if (root.isLeaf()) {
            pd.getWidth().assign(d.getWidth());
            this.maxLeafWidth = Math.max(this.maxLeafWidth, pd.getWidth().getInMillimeters());
        } else {
            pd.getWidth().setInMillimeters(Math.min(root.getFormats().getCornerRadius().getInMillimeters() + root.getFormats().getLineWidth().getInMillimeters(), 0.5f * root.getPosition(this.type).getHeight().getInMillimeters()));
            result += pd.getWidth().getInMillimeters();
        }
        pd.getLeft().setInMillimeters(-result);
        if (root.hasAfferentBranch()) {
            Branch b = root.getAfferentBranch();
            b.getPosition(this.type).getWidth().setInMillimeters(Math.max(this.labelBlockWidth(b.getLabels()), b.getFormats().getMinLength().getInMillimeters()));
            b.getPosition(this.type).getLeft().setInMillimeters(-(result += b.getPosition(this.type).getWidth().getInMillimeters()));
        }
        return result;
    }

    private void positionLabelBlockX(Branch branch, boolean above) {
        int lineNo = 0;
        while (lineNo < branch.getLabels().lineCount(above)) {
            float lengthDif = branch.getPosition(this.type).getWidth().getInMillimeters() - this.labelLineWidth(branch.getLabels(), above, lineNo);
            float left = branch.getPosition(this.type).getLeft().getInMillimeters();
            left = lengthDif > 0.0f || !this.document.getTree().getFormats().getPositionLabelsToLeft() ? (left += 0.5f * lengthDif) : (left += lengthDif);
            int pos = 0;
            while (pos < branch.getLabels().labelCount(above, lineNo)) {
                Label l = branch.getLabels().get(above, lineNo, pos);
                PositionData pd = l.getPosition(this.type);
                pd.getLeft().setInMillimeters(left += l.getFormats().getMargin().getLeft().getInMillimeters());
                left += pd.getWidth().getInMillimeters() + l.getFormats().getMargin().getRight().getInMillimeters();
                ++pos;
            }
            ++lineNo;
        }
    }

    private void positionLabelBlockY(Branch branch) {
        float top;
        Margin m;
        float height;
        PositionData pd;
        Label l;
        int pos;
        float lineHeight;
        int count;
        float y = branch.getPosition(this.type).getTop().getInMillimeters();
        int lineNo = 0;
        while (lineNo < branch.getLabels().lineCount(true)) {
            count = branch.getLabels().labelCount(true, lineNo);
            if (count > 0) {
                lineHeight = this.labelLineHeight(branch.getLabels(), true, lineNo);
                y -= lineHeight;
                pos = 0;
                while (pos < count) {
                    l = branch.getLabels().get(true, lineNo, pos);
                    pd = l.getPosition(this.type);
                    height = pd.getHeight().getInMillimeters();
                    top = Math.max(0.5f * (lineHeight - height), (m = l.getFormats().getMargin()).getTop().getInMillimeters());
                    if (top + height + m.getBottom().getInMillimeters() > lineHeight) {
                        top = lineHeight - height - m.getBottom().getInMillimeters();
                    }
                    pd.getTop().setInMillimeters(y + top);
                    ++pos;
                }
            }
            ++lineNo;
        }
        y = branch.getPosition(this.type).getBottomInMillimeters();
        lineNo = 0;
        while (lineNo < branch.getLabels().lineCount(false)) {
            count = branch.getLabels().labelCount(false, lineNo);
            if (count > 0) {
                lineHeight = this.labelLineHeight(branch.getLabels(), false, lineNo);
                pos = 0;
                while (pos < count) {
                    l = branch.getLabels().get(false, lineNo, pos);
                    pd = l.getPosition(this.type);
                    height = pd.getHeight().getInMillimeters();
                    top = Math.max(0.5f * (lineHeight - height), (m = l.getFormats().getMargin()).getTop().getInMillimeters());
                    if (top + height + m.getBottom().getInMillimeters() > lineHeight) {
                        top = lineHeight - height - m.getBottom().getInMillimeters();
                    }
                    pd.getTop().setInMillimeters(y + top);
                    ++pos;
                }
                y += lineHeight;
            }
            ++lineNo;
        }
    }

    protected float calculateCornerRadiusShift(Node node, float y) {
        float halfLineWidth = 0.5f * node.getFormats().getLineWidth().getInMillimeters();
        float cornerRadius = Math.min(node.getFormats().getCornerRadius().getInMillimeters(), 0.5f * node.getPosition(this.type).getHeight().getInMillimeters() - node.getFormats().getLineWidth().getInMillimeters());
        float nodeHeight = node.getPosition(this.type).getHeight().getInMillimeters();
        float yCircle = 0.0f;
        if (Math2.isBetween(y -= node.getPosition(this.type).getTop().getInMillimeters(), halfLineWidth + cornerRadius, nodeHeight - halfLineWidth - cornerRadius)) {
            return -cornerRadius;
        }
        if (Math2.isBetween(y, halfLineWidth, halfLineWidth + cornerRadius)) {
            yCircle = -(y - halfLineWidth - cornerRadius);
        } else if (Math2.isBetween(y, nodeHeight - halfLineWidth - cornerRadius, nodeHeight - halfLineWidth)) {
            yCircle = y - nodeHeight + halfLineWidth + cornerRadius;
        } else {
            return 0.0f;
        }
        return -((float)Math.sqrt(Math.pow(cornerRadius, 2.0) - Math.pow(yCircle, 2.0))) - 0.5f * node.getFormats().getLineWidth().getInMillimeters();
    }

    private float positionElements(Node root, float overallWidth, float y0) {
        NodePositionData pd = root.getPosition(this.type);
        pd.getLeft().add(overallWidth);
        if (root.hasAfferentBranch()) {
            PositionData branchPos = root.getAfferentBranch().getPosition(this.type);
            branchPos.getTop().setInMillimeters(y0 + pd.getHeightAbove());
            if (root.hasParent()) {
                branchPos.getTop().add(-0.5f * branchPos.getHeight().getInMillimeters());
                float cornerRadiusShift = this.calculateCornerRadiusShift(root.getParent(), branchPos.getTop().getInMillimeters() + 0.5f * branchPos.getHeight().getInMillimeters());
                branchPos.getLeft().add(cornerRadiusShift);
                branchPos.getWidth().add(-cornerRadiusShift);
            }
            this.positionLabelBlockX(root.getAfferentBranch(), true);
            this.positionLabelBlockX(root.getAfferentBranch(), false);
            this.positionLabelBlockY(root.getAfferentBranch());
        }
        pd.getTop().setInMillimeters(y0 + pd.getDifAbove());
        if (!root.isLeaf()) {
            float currentY0 = y0 + pd.getDifAbove() - root.getChildren().get(0).getPosition(this.type).getHeightAbove();
            float newX = pd.getLeft().getInMillimeters() + pd.getWidth().getInMillimeters();
            int i = 0;
            while (i < root.getChildren().size()) {
                PositionData childPD = root.getChildren().get(i).getAfferentBranch().getPosition(this.type);
                childPD.getWidth().add(childPD.getLeft().getInMillimeters() + overallWidth - newX);
                childPD.getLeft().setInMillimeters(newX);
                currentY0 = this.positionElements(root.getChildren().get(i), overallWidth, currentY0);
                ++i;
            }
        }
        return y0 + pd.getHeightAbove() + pd.getHeightBelow();
    }

    protected void calculatePaintDimension(float overallWidth, float overallHeight) {
        GlobalFormats gf = this.document.getTree().getFormats();
        this.document.getTree().getPaintDimension(this.type).getWidth().setInMillimeters(gf.getDocumentMargin().getLeft().getInMillimeters() + overallWidth + gf.getDocumentMargin().getRight().getInMillimeters());
        this.document.getTree().getPaintDimension(this.type).getHeight().setInMillimeters(gf.getDocumentMargin().getTop().getInMillimeters() + overallHeight + gf.getDocumentMargin().getBottom().getInMillimeters());
    }

    protected float rescaleNodeWidth(Node node, float width) {
        return width;
    }

    protected float rescaleBranchWidth(Branch branch, float width) {
        if (branch.getTargetNode().hasParent()) {
            float nodeWidth = branch.getTargetNode().getParent().getPosition(this.type).getWidth().getInMillimeters();
            return (width + nodeWidth) * this.rescalingFactorX - nodeWidth;
        }
        return width * this.rescalingFactorX;
    }

    private float rescaleSubtree(Node root, float shift) {
        float newWidth;
        float oldWidth;
        if (root.hasAfferentBranch()) {
            PositionData branchPD = root.getAfferentBranch().getPosition(this.type);
            branchPD.getLeft().add(shift);
            oldWidth = branchPD.getWidth().getInMillimeters();
            newWidth = this.rescaleBranchWidth(root.getAfferentBranch(), oldWidth);
            branchPD.getWidth().setInMillimeters(newWidth);
            this.positionLabelBlockX(root.getAfferentBranch(), true);
            this.positionLabelBlockX(root.getAfferentBranch(), false);
            shift += newWidth - oldWidth;
        }
        NodePositionData nodePD = root.getPosition(this.type);
        nodePD.getLeft().add(shift);
        oldWidth = nodePD.getWidth().getInMillimeters();
        newWidth = this.rescaleNodeWidth(root, oldWidth);
        nodePD.getWidth().setInMillimeters(newWidth);
        shift += newWidth - oldWidth;
        float maxWidth = root.getAfferentBranch().getPosition(this.type).getRightInMillimeters();
        int i = 0;
        while (i < root.getChildren().size()) {
            maxWidth = Math.max(maxWidth, this.rescaleSubtree(root.getChildren().get(i), shift));
            ++i;
        }
        return maxWidth;
    }

    private float getLegendStartX(LegendFormats f, float treeRight) {
        if (this.document.getTree().getFormats().getAlignLegendsToSubtree()) {
            f.sortAnchors(this.type);
            Node lowerAnchor = f.getAnchor(1);
            if (lowerAnchor == null) {
                lowerAnchor = f.getAnchor(0);
            }
            Node[] leaves = TreeSerializer.getLeafNodesBetween(f.getAnchor(0).getHighestChild(), lowerAnchor.getLowestChild());
            float result = 0.0f;
            int i = 0;
            while (i < leaves.length) {
                result = Math.max(result, leaves[i].getPosition(this.type).getRightInMillimeters());
                ++i;
            }
            return result;
        }
        return treeRight;
    }

    private float alignToOtherLegends(Legends legends, int start, int end, float minLeft, float top, float bottom) {
        float leftMargin = legends.get(end + 1).getFormats().getMargin().getLeft().getInMillimeters();
        int j = start;
        while (j <= end) {
            float otherBottom;
            LegendPositionData otherPD = legends.get(j).getPosition(this.type);
            Margin m = legends.get(j).getFormats().getMargin();
            float otherTop = otherPD.getTop().getInMillimeters() - m.getTop().getInMillimeters();
            if (Math2.overlapsNE(top, bottom, otherTop, otherBottom = otherPD.getBottomInMillimeters() + m.getBottom().getInMillimeters())) {
                minLeft = Math.max(minLeft, otherPD.getRightInMillimeters() + leftMargin + m.getRight().getInMillimeters());
            }
            ++j;
        }
        return minLeft;
    }

    private float getLegendTop(LegendFormats f) {
        Node anchor = f.getAnchor(0).getHighestChild();
        return anchor.getPosition(this.type).getTop().getInMillimeters() + anchor.getFormats().getLeafMargin().getTop().getInMillimeters();
    }

    private float getLegendBottom(LegendFormats f) {
        Node anchor = f.hasOneAnchor() ? f.getAnchor(0).getLowestChild() : f.getAnchor(1).getLowestChild();
        return anchor.getPosition(this.type).getBottomInMillimeters() - anchor.getFormats().getLeafMargin().getBottom().getInMillimeters();
    }

    private float positionLegends(float startX) {
        float result = startX;
        Legends legends = this.document.getTree().getLegends();
        int i = 0;
        while (i < legends.size()) {
            LegendPositionData pd;
            int lastPositionIndex = legends.get(i).getFormats().getPosition();
            int positionIndexStart = i;
            float positionLeft = 0.0f;
            while (i < legends.size() && legends.get(i).getFormats().getPosition() == lastPositionIndex) {
                Legend l = legends.get(i);
                LegendFormats f = l.getFormats();
                pd = l.getPosition(this.type);
                Margin m = l.getFormats().getMargin();
                f.sortAnchors(this.type);
                float top = this.getLegendTop(f);
                float bottom = this.getLegendBottom(f);
                pd.getLinePos().getTop().setInMillimeters(top);
                pd.getLinePos().getHeight().setInMillimeters(bottom - top);
                DistanceDimension textDim = PositionPaintUtils.calculateTextDimension(l);
                if (f.getOrientation().equals((Object)TextOrientation.HORIZONTAL)) {
                    pd.getTextPos().getWidth().assign(textDim.getWidth());
                    pd.getTextPos().getHeight().assign(textDim.getHeight());
                } else {
                    pd.getTextPos().getWidth().assign(textDim.getHeight());
                    pd.getTextPos().getHeight().assign(textDim.getWidth());
                }
                float heightDif = pd.getTextPos().getHeight().getInMillimeters() - (bottom - top);
                if (heightDif > 0.0f) {
                    pd.getTextPos().getTop().setInMillimeters(top -= (heightDif /= 2.0f));
                    bottom += heightDif;
                } else {
                    pd.getTextPos().getTop().setInMillimeters(top + 0.5f * pd.getLinePos().getHeight().getInMillimeters() - 0.5f * pd.getTextPos().getHeight().getInMillimeters());
                }
                positionLeft = Math.max(positionLeft, this.getLegendStartX(f, startX) + m.getLeft().getInMillimeters() + f.getMinTreeDistance().getInMillimeters());
                positionLeft = this.alignToOtherLegends(legends, 0, positionIndexStart - 1, positionLeft, top -= m.getTop().getInMillimeters(), bottom += m.getBottom().getInMillimeters());
                ++i;
            }
            --i;
            int j = positionIndexStart;
            while (j <= i) {
                Legend l = legends.get(j);
                pd = l.getPosition(this.type);
                LegendFormats f = l.getFormats();
                Margin m = l.getFormats().getMargin();
                float left = this.alignToOtherLegends(legends, positionIndexStart, j - 1, positionLeft, this.getLegendTop(f) - m.getTop().getInMillimeters(), this.getLegendBottom(f) + m.getBottom().getInMillimeters());
                pd.getLinePos().getLeft().setInMillimeters(left);
                float width = l.getFormats().getSpacing().getInMillimeters();
                width = l.getFormats().getLegendStyle().equals((Object)LegendStyle.BRACE) ? (width += Math.min(2.0f * f.getCornerRadius().getInMillimeters() + f.getLineWidth().getInMillimeters(), 0.5f * pd.getLinePos().getHeight().getInMillimeters())) : (width += f.getCornerRadius().getInMillimeters() + f.getLineWidth().getInMillimeters());
                pd.getLinePos().getWidth().setInMillimeters(width);
                pd.getTextPos().getLeft().setInMillimeters(left + width);
                result = Math.max(result, left + (width += pd.getTextPos().getWidth().getInMillimeters()) + m.getRight().getInMillimeters());
                ++j;
            }
            ++i;
        }
        return result;
    }

    private float positionScaleBar(float treeWidth, float maxTreeY) {
        ScaleBar scaleBar = this.document.getTree().getScaleBar();
        if (scaleBar == null) {
            return maxTreeY;
        }
        float branchLengthScale = this.document.getTree().getFormats().getBranchLengthScale().getInMillimeters();
        PositionData pd = scaleBar.getPosition(this.type);
        ScaleBarFormats f = scaleBar.getFormats();
        switch (f.getAlignment()) {
            case LEFT: 
            case RIGHT: {
                pd.getWidth().setInMillimeters(f.getWidth().getInMillimeters(branchLengthScale));
                break;
            }
            case TREE_WIDTH: {
                pd.getWidth().setInMillimeters(treeWidth);
            }
        }
        pd.getHeight().assign(f.getHeight());
        pd.getHeight().add(f.getTextHeight().getInMillimeters());
        if (!scaleBar.getData().isEmpty() && !scaleBar.getData().getText().equals("")) {
            pd.getHeight().add(f.getTextHeight().getInMillimeters());
        }
        switch (f.getAlignment()) {
            case LEFT: 
            case TREE_WIDTH: {
                pd.getLeft().setInMillimeters(0.0f);
                break;
            }
            case RIGHT: {
                pd.getLeft().setInMillimeters(treeWidth - f.getWidth().getInMillimeters(branchLengthScale));
            }
        }
        pd.getTop().setInMillimeters(maxTreeY + f.getTreeDistance().getInMillimeters());
        return pd.getTop().getInMillimeters() + pd.getHeight().getInMillimeters();
    }

    private void movePosition(PositionData pd, float dX, float dY) {
        pd.getLeft().add(dX);
        pd.getTop().add(dY);
    }

    private void moveLabels(Labels labels, boolean above, float dX, float dY) {
        int lineNo = 0;
        while (lineNo < labels.lineCount(above)) {
            int lineIndex = 0;
            while (lineIndex < labels.labelCount(above, lineNo)) {
                this.movePosition(labels.get(above, lineNo, lineIndex).getPosition(this.type), dX, dY);
                ++lineIndex;
            }
            ++lineNo;
        }
    }

    private void moveSubtree(Node root, float dX, float dY) {
        if (root.hasAfferentBranch()) {
            Branch b = root.getAfferentBranch();
            this.movePosition(b.getPosition(this.type), dX, dY);
            this.moveLabels(b.getLabels(), true, dX, dY);
            this.moveLabels(b.getLabels(), false, dX, dY);
        }
        this.movePosition(root.getPosition(this.type), dX, dY);
        int i = 0;
        while (i < root.getChildren().size()) {
            this.moveSubtree(root.getChildren().get(i), dX, dY);
            ++i;
        }
    }

    private void moveAll(float dX, float dY) {
        if (!this.document.getTree().isEmpty()) {
            this.moveSubtree(this.document.getTree().getPaintStart(), dX, dY);
        }
        if (this.document.getTree().getFormats().getShowScaleBar()) {
            this.movePosition(this.document.getTree().getScaleBar().getPosition(this.type), dX, dY);
        }
        Legends legends = this.document.getTree().getLegends();
        int i = 0;
        while (i < legends.size()) {
            LegendPositionData pd = legends.get(i).getPosition(this.type);
            this.movePosition(pd.getLinePos(), dX, dY);
            this.movePosition(pd.getTextPos(), dX, dY);
            ++i;
        }
    }

    private float invisibleRootBranchOffset() {
        Branch rootBranch = this.document.getTree().getPaintStart().getAfferentBranch();
        return Math.max(0.0f, this.labelBlockWidth(rootBranch.getLabels()) - rootBranch.getPosition(this.type).getWidth().getInMillimeters());
    }

    private float moveForLegends() {
        PositionData pd;
        Margin m = this.document.getTree().getFormats().getDocumentMargin();
        float top = m.getTop().getInMillimeters();
        float bottom = 0.0f;
        Legends legends = this.document.getTree().getLegends();
        int i = 0;
        while (i < legends.size()) {
            pd = legends.get(i).getPosition(this.type);
            top = Math.min(top, ((LegendPositionData)pd).getTop().getInMillimeters());
            bottom = Math.max(bottom, pd.getBottomInMillimeters());
            ++i;
        }
        float dTop = m.getTop().getInMillimeters() - top;
        this.moveAll(this.document.getTree().getFormats().getDocumentMargin().getLeft().getInMillimeters() + this.invisibleRootBranchOffset(), dTop);
        pd = this.document.getTree().getPaintStart().getPosition(this.type);
        float treeHeight = ((NodePositionData)pd).getHeightAbove() + ((NodePositionData)pd).getHeightBelow();
        return dTop + treeHeight + Math.max(0.0f, bottom - (treeHeight + m.getTop().getInMillimeters()));
    }

    @Override
    public void positionAll(Document document, float rescalingFactorX) {
        this.document = document;
        this.rescalingFactorX = rescalingFactorX;
        this.maxLeafWidth = 0.0f;
        if (!document.getTree().isEmpty()) {
            float overallWidth = this.calculateWidthsHeights(document.getTree().getPaintStart());
            Branch rootBranch = document.getTree().getPaintStart().getAfferentBranch();
            if (rootBranch != null && !document.getTree().getFormats().getShowRooted()) {
                overallWidth -= rootBranch.getPosition(this.type).getWidth().getInMillimeters();
                rootBranch.getPosition(this.type).getWidth().setInMillimeters(0.0f);
            }
            float overallHeight = this.positionElements(document.getTree().getPaintStart(), overallWidth, document.getTree().getFormats().getDocumentMargin().getTop().getInMillimeters());
            if (rootBranch != null) {
                rootBranch.getPosition(this.type).getLeft().setInMillimeters(0.0f);
            }
            overallWidth = this.rescaleSubtree(document.getTree().getPaintStart(), 0.0f);
            float newHeight = this.positionScaleBar(overallWidth, overallHeight);
            overallWidth += this.maxLeafWidth;
            if (document.getTree().getFormats().getShowScaleBar()) {
                overallHeight = newHeight;
            }
            overallWidth = this.positionLegends(overallWidth);
            overallHeight = Math.max(overallHeight, this.moveForLegends());
            if (rootBranch != null && !rootBranch.getLabels().isEmpty()) {
                float rootBranchWidth = rootBranch.getPosition(this.type).getWidth().getInMillimeters();
                overallWidth += Math.max(rootBranchWidth, this.labelBlockWidth(rootBranch.getLabels())) - rootBranchWidth;
            }
            this.calculatePaintDimension(overallWidth, overallHeight);
        } else {
            this.calculatePaintDimension(0.0f, 0.0f);
        }
    }

    private AbstractPaintableElement searchLabelBlock(Branch branch, float x, float y, float margin) {
        boolean above = false;
        if (y <= branch.getPosition(this.type).getTop().getInMillimeters()) {
            above = true;
        }
        int lineNo = 0;
        while (lineNo < branch.getLabels().lineCount(above)) {
            int lineIndex = 0;
            while (lineIndex < branch.getLabels().labelCount(above, lineNo)) {
                Label label = branch.getLabels().get(above, lineNo, lineIndex);
                if (label.getPosition(this.type).contains(x, y, margin)) {
                    return label;
                }
                ++lineIndex;
            }
            ++lineNo;
        }
        return null;
    }

    protected boolean xToLow(float x, PositionData pd) {
        return x < pd.getLeft().getInMillimeters();
    }

    private AbstractPaintableElement searchElementToPosition(Node root, float x, float y, float margin) {
        NodePositionData pd = root.getPosition(this.type);
        float centerY = pd.getTop().getInMillimeters() + 0.5f * pd.getHeight().getInMillimeters();
        if (Math2.isBetween(y, centerY - pd.getHeightAbove(), centerY + pd.getHeightBelow())) {
            if (root.hasAfferentBranch()) {
                if (root.hasParent() && this.xToLow(x, root.getAfferentBranch().getPosition(this.type))) {
                    return null;
                }
                if (root.getAfferentBranch().getPosition(this.type).contains(x, y, margin)) {
                    if (root.getPosition(this.type).contains(x, y, margin)) {
                        return root;
                    }
                    return root.getAfferentBranch();
                }
                AbstractPaintableElement result = this.searchLabelBlock(root.getAfferentBranch(), x, y, margin);
                if (result != null) {
                    return result;
                }
            }
            if (this.xToLow(x, pd)) {
                return null;
            }
            if (root.getPosition(this.type).contains(x, y, margin)) {
                return root;
            }
            int i = 0;
            while (i < root.getChildren().size()) {
                AbstractPaintableElement result = this.searchElementToPosition(root.getChildren().get(i), x, y, margin);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public AbstractPaintableElement elementToPosition(Document document, float x, float y, float margin) {
        AbstractPaintableElement result;
        this.document = document;
        if (!document.getTree().isEmpty() && (result = this.searchElementToPosition(document.getTree().getPaintStart(), x, y, margin)) != null) {
            return result;
        }
        if (document.getTree().getFormats().getShowScaleBar() && document.getTree().getScaleBar().getPosition(this.type).contains(x, y, margin)) {
            return document.getTree().getScaleBar();
        }
        Legends legends = document.getTree().getLegends();
        int i = 0;
        while (i < legends.size()) {
            if (legends.get(i).getPosition(this.type).contains(x, y, margin)) {
                return legends.get(i);
            }
            ++i;
        }
        return null;
    }
}

