/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.AbstractPaintableElement;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Legends;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.ScaleBar;
import info.bioinfweb.treegraph.document.format.BranchFormats;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.document.format.LegendFormats;
import info.bioinfweb.treegraph.document.format.LegendStyle;
import info.bioinfweb.treegraph.document.format.Margin;
import info.bioinfweb.treegraph.document.format.NodeFormats;
import info.bioinfweb.treegraph.document.format.ScaleBarFormats;
import info.bioinfweb.treegraph.document.format.ScaleValue;
import info.bioinfweb.treegraph.document.format.TextFormats;
import info.bioinfweb.treegraph.document.format.TextOrientation;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintType;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintUtils;
import info.bioinfweb.treegraph.graphics.positionpaint.TreePainter;
import info.bioinfweb.treegraph.graphics.positionpaint.label.LabelPainter;
import info.bioinfweb.treegraph.graphics.positionpaint.label.LabelPainterMap;
import info.bioinfweb.treegraph.graphics.positionpaint.positiondata.LegendPositionData;
import info.bioinfweb.treegraph.graphics.positionpaint.positiondata.NodePositionData;
import info.bioinfweb.treegraph.graphics.positionpaint.positiondata.PositionData;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanel;
import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

public class RectangularCladogramPainter
implements TreePainter {
    public static final float SELECTION_DISTANCE = 2.0f;
    public static final float SHORT_DASH_SCALE_FACTOR = 0.5f;
    private static RectangularCladogramPainter firstInstance = null;
    protected final PositionPaintType type = PositionPaintFactory.getInstance().getType(this);
    private Graphics2D g = null;
    private Rectangle visibleRect = null;
    private Document document = null;
    private TreeSelection selection = null;
    private float pixelsPerMillimeter = 1.0f;

    protected RectangularCladogramPainter() {
    }

    public static RectangularCladogramPainter getInstance() {
        if (firstInstance == null) {
            firstInstance = new RectangularCladogramPainter();
        }
        return firstInstance;
    }

    private void paintSelection(AbstractPaintableElement element) {
        if (this.selection != null && this.selection.contains(element)) {
            this.g.setColor(TreeViewPanel.selectionColor(this.document.getTree().getFormats().getBackgroundColor()));
            PositionData pd = element.getPosition(this.type);
            this.g.draw(new Rectangle2D.Float(pd.getLeft().getInPixels(this.pixelsPerMillimeter) - 2.0f, pd.getTop().getInPixels(this.pixelsPerMillimeter) - 2.0f, pd.getWidth().getInPixels(this.pixelsPerMillimeter) + 4.0f, pd.getHeight().getInPixels(this.pixelsPerMillimeter) + 4.0f));
        }
    }

    private float paintText(String text, TextFormats f, float x, float y) {
        return PositionPaintUtils.paintText(this.g, this.pixelsPerMillimeter, text, f, x, y);
    }

    private void paintBranch(Branch b) {
        float startWidth;
        PositionData pd = b.getPosition(this.type);
        BranchFormats bf = b.getFormats();
        Node n = b.getTargetNode();
        boolean parentHasEdgeRadius = false;
        if (n.hasParent() && !bf.isConstantWidth()) {
            startWidth = n.getParent().getFormats().getLineWidth().getInPixels(this.pixelsPerMillimeter);
            parentHasEdgeRadius = n.getParent().getFormats().getCornerRadius().getInMillimeters() > 0.0f;
        } else {
            startWidth = bf.getLineWidth().getInPixels(this.pixelsPerMillimeter);
        }
        float middle = pd.getTop().getInPixels(this.pixelsPerMillimeter) + 0.5f * pd.getHeight().getInPixels(this.pixelsPerMillimeter);
        float halfHeightLeft = 0.5f * startWidth;
        float halfHeightRight = 0.5f * b.getFormats().getLineWidth().getInPixels(this.pixelsPerMillimeter);
        float left = pd.getLeft().getInPixels(this.pixelsPerMillimeter);
        if (!n.isFirst() && !n.isLast() || !parentHasEdgeRadius) {
            left = (int)left;
        }
        float right = pd.getRightInPixels(this.pixelsPerMillimeter);
        if (!n.isLeaf()) {
            right = Math2.roundUp(right);
        }
        Path2D.Float path = new Path2D.Float();
        ((Path2D)path).moveTo(left, middle - halfHeightLeft);
        ((Path2D)path).lineTo(right, middle - halfHeightRight);
        ((Path2D)path).lineTo(right, middle + halfHeightRight);
        ((Path2D)path).lineTo(left, middle + halfHeightLeft);
        path.closePath();
        this.g.setColor(b.getFormats().getLineColor());
        this.g.fill(path);
        this.paintSelection(b);
    }

    private void paintLabelBlock(Labels labels, boolean above) {
        int lineNo = 0;
        while (lineNo < labels.lineCount(above)) {
            int i = 0;
            while (i < labels.labelCount(above, lineNo)) {
                Label label = labels.get(above, lineNo, i);
                PositionData pd = label.getPosition(this.type);
                LabelPainter<Label, ?> painter = LabelPainterMap.getInstance().getLabelPainter(label);
                if (painter == null) {
                    throw new InternalError("Unsupported label of type " + label.getClass().getCanonicalName() + " found.");
                }
                painter.paint(this.g, this.pixelsPerMillimeter, pd, label);
                this.paintSelection(label);
                ++i;
            }
            ++lineNo;
        }
    }

    private void paintInternalNode(Node n) {
        Stroke oldStroke = this.g.getStroke();
        NodePositionData pd = n.getPosition(this.type);
        float width = n.getFormats().getLineWidth().getInPixels(this.pixelsPerMillimeter);
        float left = pd.getLeft().getInPixels(this.pixelsPerMillimeter) + 0.5f * width;
        float dY = -0.5f * width;
        float cornerRadius = Math.min(n.getFormats().getCornerRadius().getInPixels(this.pixelsPerMillimeter), pd.getWidth().getInPixels(this.pixelsPerMillimeter) - width);
        if (cornerRadius > 0.0f) {
            dY = width + cornerRadius;
        }
        float top = pd.getTop().getInPixels(this.pixelsPerMillimeter) + dY;
        float height = Math.max(0.0f, pd.getHeight().getInPixels(this.pixelsPerMillimeter) - 2.0f * dY);
        this.g.setStroke(new BasicStroke(width, 0, 2));
        this.g.setColor(n.getFormats().getLineColor());
        if (cornerRadius > 0.0f) {
            Path2D.Float path = new Path2D.Float();
            float length = 2.0f * cornerRadius;
            float topEdge = pd.getTop().getInPixels(this.pixelsPerMillimeter);
            float verticalLeft = left + cornerRadius + 0.5f * width;
            path.append(new Line2D.Float(Math2.roundUp(verticalLeft), topEdge, verticalLeft, topEdge), false);
            path.append(new Arc2D.Float(left, topEdge, length, length, 90.0f, 90.0f, 0), true);
            path.append(new Line2D.Float(left, top, left, top + height), true);
            path.append(new Arc2D.Float(left, topEdge + (height += 2.0f * width), length, length, 180.0f, 90.0f, 0), true);
            path.append(new Line2D.Float(verticalLeft, topEdge + height + 2.0f * cornerRadius, Math2.roundUp(verticalLeft), topEdge + height + 2.0f * cornerRadius), true);
            this.g.draw(path);
        } else {
            float upperHeightDiff = 0.0f;
            float lowerHeightDiff = 0.0f;
            BranchFormats formats = n.getChildren().get(0).getAfferentBranch().getFormats();
            if (formats.isConstantWidth()) {
                upperHeightDiff = 0.5f * (formats.getLineWidth().getInPixels(this.pixelsPerMillimeter) - n.getFormats().getLineWidth().getInPixels(this.pixelsPerMillimeter));
            }
            if ((formats = n.getChildren().get(n.getChildren().size() - 1).getAfferentBranch().getFormats()).isConstantWidth()) {
                lowerHeightDiff = 0.5f * (formats.getLineWidth().getInPixels(this.pixelsPerMillimeter) - n.getFormats().getLineWidth().getInPixels(this.pixelsPerMillimeter));
            }
            this.g.draw(new Line2D.Float(left, top - upperHeightDiff, left, top + height + lowerHeightDiff));
        }
        this.g.setStroke(oldStroke);
        this.paintSelection(n);
    }

    private void paintPointNode(Node n) {
        float radius = 1.5f * n.getFormats().getLineWidth().getInPixels(this.pixelsPerMillimeter);
        NodePositionData pd = n.getPosition(this.type);
        this.g.setColor(n.getFormats().getLineColor());
        this.g.fill(new Ellipse2D.Float(pd.getLeft().getInPixels(this.pixelsPerMillimeter) + 0.5f * pd.getWidth().getInPixels(this.pixelsPerMillimeter) - radius, pd.getTop().getInPixels(this.pixelsPerMillimeter) + 0.5f * pd.getHeight().getInPixels(this.pixelsPerMillimeter) - radius, 2.0f * radius, 2.0f * radius));
        this.paintSelection(n);
    }

    private void paintLeaf(Node leaf) {
        NodePositionData pd = leaf.getPosition(this.type);
        NodeFormats f = leaf.getFormats();
        Margin m = leaf.getFormats().getLeafMargin();
        this.paintText(leaf.getData().formatValue(f.getDecimalFormat()), f, pd.getLeft().getInPixels(this.pixelsPerMillimeter) + m.getLeft().getInPixels(this.pixelsPerMillimeter), pd.getTop().getInPixels(this.pixelsPerMillimeter) + m.getTop().getInPixels(this.pixelsPerMillimeter) + (float)this.g.getFontMetrics(f.getFont(this.pixelsPerMillimeter)).getAscent());
        this.paintSelection(leaf);
    }

    private boolean subtreeVisible(Node root) {
        NodePositionData pd = root.getPosition(this.type);
        float middle = pd.getTop().getInPixels(this.pixelsPerMillimeter) + 0.5f * pd.getHeight().getInPixels(this.pixelsPerMillimeter);
        boolean notVisible = root.getAfferentBranch().getPosition(this.type).getLeft().getRoundedInPixels(this.pixelsPerMillimeter) > this.visibleRect.x + this.visibleRect.width || (float)this.visibleRect.y > middle + (float)Math2.roundUp(pd.getHeightBelow() * this.pixelsPerMillimeter) || (float)(this.visibleRect.y + this.visibleRect.height) < middle - (float)Math2.roundUp(pd.getHeightAbove() * this.pixelsPerMillimeter);
        return !notVisible;
    }

    private void paintSubtree(Node root) {
        if (this.subtreeVisible(root)) {
            if (root.hasAfferentBranch()) {
                if (root.hasParent() || this.document.getTree().getFormats().getShowRooted()) {
                    this.paintBranch(root.getAfferentBranch());
                }
                this.paintLabelBlock(root.getAfferentBranch().getLabels(), true);
                this.paintLabelBlock(root.getAfferentBranch().getLabels(), false);
            }
            if (root.getChildren().size() == 0) {
                this.paintLeaf(root);
            } else {
                if (root.getChildren().size() == 1) {
                    this.paintPointNode(root);
                } else {
                    this.paintInternalNode(root);
                }
                int i = 0;
                while (i < root.getChildren().size()) {
                    this.paintSubtree(root.getChildren().get(i));
                    ++i;
                }
            }
        }
    }

    private void paintScaleBar(ScaleBar scaleBar) {
        Stroke previousStroke = this.g.getStroke();
        ScaleBarFormats f = scaleBar.getFormats();
        PositionData pd = scaleBar.getPosition(this.type);
        this.g.setColor(f.getLineColor());
        this.g.setStroke(new BasicStroke(f.getLineWidth().getInPixels(this.pixelsPerMillimeter)));
        float baseLineY = pd.getTop().getInPixels(this.pixelsPerMillimeter) + f.getHeight().getInPixels(this.pixelsPerMillimeter);
        float left = pd.getLeft().getInPixels(this.pixelsPerMillimeter);
        float right = pd.getLeft().getInPixels(this.pixelsPerMillimeter) + pd.getWidth().getInPixels(this.pixelsPerMillimeter);
        this.g.draw(new Line2D.Float(left, baseLineY, right, baseLineY));
        float branchLengthScale = this.document.getTree().getFormats().getBranchLengthScale().getInPixels(this.pixelsPerMillimeter);
        float shortDashY = baseLineY - f.getHeight().getInPixels(this.pixelsPerMillimeter) * 0.5f;
        float longDashY = pd.getTop().getInPixels(this.pixelsPerMillimeter);
        FontMetrics fm = this.g.getFontMetrics(f.getFont(this.pixelsPerMillimeter));
        float start = left;
        float end = right;
        float step = ScaleValue.branchLengthToDistance(f.getSmallInterval(), branchLengthScale);
        if (!f.isStartLeft()) {
            start = right;
            end = left;
            step = -step;
        }
        int dashCount = 0;
        this.g.setStroke(new BasicStroke(0.0f, 0, 2));
        float halfLineWidth = f.getLineWidth().getInPixels(this.pixelsPerMillimeter) / 2.0f;
        float x = start;
        while (x <= end && step > 0.0f || x >= end && step < 0.0f) {
            Path2D.Float path = new Path2D.Float();
            if (dashCount % f.getLongInterval() == 0) {
                ((Path2D)path).moveTo(x - halfLineWidth, longDashY);
                ((Path2D)path).lineTo(x + halfLineWidth, longDashY);
                float value = (float)dashCount * f.getSmallInterval();
                if (!f.isIncreasing()) {
                    value = -value;
                }
                String labelText = f.getDecimalFormat().format(value);
                float labelWidth = fm.stringWidth(labelText);
                float labelX = x;
                if (!f.isStartLeft()) {
                    labelX -= labelWidth;
                }
                if (labelX >= left && labelX + labelWidth <= right) {
                    this.paintText(labelText, scaleBar.getFormats(), labelX, baseLineY + (float)fm.getAscent());
                    this.g.setColor(f.getLineColor());
                }
            } else {
                ((Path2D)path).moveTo(x - halfLineWidth, shortDashY);
                ((Path2D)path).lineTo(x + halfLineWidth, shortDashY);
            }
            ((Path2D)path).lineTo(x + halfLineWidth, baseLineY);
            ((Path2D)path).lineTo(x - halfLineWidth, baseLineY);
            path.closePath();
            this.g.fill(path);
            ++dashCount;
            x += step;
        }
        String text = scaleBar.getData().formatValue(scaleBar.getFormats().getDecimalFormat());
        float unitX = left;
        if (!f.isStartLeft()) {
            unitX = right - (float)fm.stringWidth(text);
        }
        this.paintText(text, scaleBar.getFormats(), unitX, baseLineY + (float)fm.getHeight() + (float)fm.getAscent());
        this.g.setStroke(previousStroke);
        this.paintSelection(scaleBar);
    }

    private boolean legendVisible(Legend l) {
        LegendPositionData pd = l.getPosition(this.type);
        boolean notVisible = this.visibleRect.x > Math2.roundUp(pd.getRightInPixels(this.pixelsPerMillimeter)) || (float)(this.visibleRect.x + this.visibleRect.width) < pd.getLeft().getInPixels(this.pixelsPerMillimeter) || this.visibleRect.y > Math2.roundUp(pd.getBottomInPixels(this.pixelsPerMillimeter)) || (float)(this.visibleRect.y + this.visibleRect.height) < pd.getTop().getInPixels(this.pixelsPerMillimeter);
        return !notVisible;
    }

    private void paintLegend(Legend l) {
        if (this.legendVisible(l)) {
            float y;
            float x;
            Stroke oldStroke = this.g.getStroke();
            LegendPositionData pd = l.getPosition(this.type);
            LegendFormats f = l.getFormats();
            float lineWidth = f.getLineWidth().getInPixels(this.pixelsPerMillimeter);
            this.g.setColor(f.getLineColor());
            this.g.setStroke(new BasicStroke(lineWidth));
            if (f.getLegendStyle().equals((Object)LegendStyle.BRACE)) {
                float cornerRadius = Math.min(f.getCornerRadius().getInPixels(this.pixelsPerMillimeter), 0.5f * (pd.getLinePos().getWidth().getInPixels(this.pixelsPerMillimeter) - lineWidth - f.getSpacing().getInPixels(this.pixelsPerMillimeter)));
                float left = pd.getLinePos().getLeft().getInPixels(this.pixelsPerMillimeter) + 0.5f * lineWidth + cornerRadius;
                float dY = lineWidth + cornerRadius;
                float top = pd.getLinePos().getTop().getInPixels(this.pixelsPerMillimeter) + dY;
                float height = Math.max(0.0f, pd.getLinePos().getHeight().getInPixels(this.pixelsPerMillimeter) - 2.0f * dY);
                if (cornerRadius > 0.0f) {
                    this.g.draw(new Line2D.Float(left, top, left, top + 0.5f * height - cornerRadius));
                    this.g.draw(new Line2D.Float(left, top + 0.5f * height + cornerRadius, left, top + height));
                    float middleTop = top + 0.5f * height - cornerRadius;
                    float length = 2.0f * cornerRadius;
                    this.g.draw(new Arc2D.Float(left, middleTop - cornerRadius, length, length, 180.0f, 90.0f, 0));
                    this.g.draw(new Arc2D.Float(left, middleTop + cornerRadius, length, length, 90.0f, 90.0f, 0));
                    top = pd.getLinePos().getTop().getInPixels(this.pixelsPerMillimeter);
                    this.g.draw(new Arc2D.Float(left -= 2.0f * cornerRadius, top, length, length, 0.0f, 90.0f, 0));
                    this.g.draw(new Arc2D.Float(left, top + (height += 2.0f * lineWidth), length, length, 270.0f, 90.0f, 0));
                } else {
                    this.g.draw(new Line2D.Float(left, top, left, top + height));
                }
            } else {
                float left = pd.getLinePos().getLeft().getInPixels(this.pixelsPerMillimeter);
                float top = pd.getLinePos().getTop().getInPixels(this.pixelsPerMillimeter);
                float cornerRadius = f.getCornerRadius().getInPixels(this.pixelsPerMillimeter);
                float height = pd.getLinePos().getHeight().getInPixels(this.pixelsPerMillimeter);
                this.g.draw(new Line2D.Float(left, top, left + cornerRadius, top));
                this.g.draw(new Line2D.Float(left + cornerRadius, top, left + cornerRadius, top + height));
                this.g.draw(new Line2D.Float(left, top + height, left + cornerRadius, top + height));
            }
            this.g.setStroke(oldStroke);
            AffineTransform oldTrans = this.g.getTransform();
            AffineTransform trans = (AffineTransform)oldTrans.clone();
            TextOrientation orient = f.getOrientation();
            float ascent = this.g.getFontMetrics(l.getFormats().getFont(this.pixelsPerMillimeter)).getAscent();
            if (orient.equals((Object)TextOrientation.UP)) {
                x = pd.getTextPos().getLeft().getInPixels(this.pixelsPerMillimeter);
                y = pd.getTextPos().getBottomInPixels(this.pixelsPerMillimeter);
                trans.quadrantRotate(3, x, y);
                this.g.setTransform(trans);
            } else if (orient.equals((Object)TextOrientation.DOWN)) {
                x = pd.getTextPos().getRightInPixels(this.pixelsPerMillimeter);
                y = pd.getTextPos().getTop().getInPixels(this.pixelsPerMillimeter);
                trans.quadrantRotate(1, x, y);
                this.g.setTransform(trans);
            } else {
                x = pd.getTextPos().getLeft().getInPixels(this.pixelsPerMillimeter);
                y = pd.getTextPos().getTop().getInPixels(this.pixelsPerMillimeter);
            }
            this.paintText(l.getData().formatValue(f.getDecimalFormat()), f, x, y + ascent);
            this.g.setTransform(oldTrans);
            this.paintSelection(l);
        }
    }

    @Override
    public void paintTree(Graphics2D g, Document document, TreeSelection selection, float pixelsPerMm, boolean transparent) {
        this.paintTree(g, null, document, selection, pixelsPerMm, transparent);
    }

    @Override
    public void paintTree(Graphics2D g, Rectangle visibleRect, Document document, TreeSelection selection, float pixelsPerMillimeter, boolean transparent) {
        this.g = g;
        DistanceDimension d = document.getTree().getPaintDimension(this.type);
        if (visibleRect == null) {
            visibleRect = new Rectangle(d.getWidth().getRoundedInPixels(pixelsPerMillimeter), d.getHeight().getRoundedInPixels(pixelsPerMillimeter));
        }
        this.visibleRect = visibleRect;
        this.document = document;
        this.selection = selection;
        this.pixelsPerMillimeter = pixelsPerMillimeter;
        if (!transparent) {
            g.setColor(document.getTree().getFormats().getBackgroundColor());
            g.fillRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
        }
        if (!document.getTree().isEmpty()) {
            this.paintSubtree(document.getTree().getPaintStart());
        }
        if (document.getTree().getFormats().getShowScaleBar()) {
            this.paintScaleBar(document.getTree().getScaleBar());
        }
        Legends legends = document.getTree().getLegends();
        int i = 0;
        while (i < legends.size()) {
            this.paintLegend(legends.get(i));
            ++i;
        }
    }
}

