/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint;

import info.bioinfweb.commons.graphics.FontCalculator;
import info.bioinfweb.treegraph.document.TextElement;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.document.format.TextFormats;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class PositionPaintUtils {
    public static final float UNDERLINE_DISTANCE_FACTOR = 0.15f;
    public static final float UNDERLINE_LINE_WIDTH_FACTOR = 0.05f;

    public static DistanceDimension calculateTextDimension(TextElement textElement) {
        DistanceDimension result = new DistanceDimension();
        TextFormats formats = textElement.getFormats();
        String text = textElement.getData().formatValue(formats.getDecimalFormat());
        float height = formats.getTextHeight().getInMillimeters();
        result.getHeight().setInMillimeters(height);
        result.getWidth().setInMillimeters(FontCalculator.getInstance().getTextWidthToTextHeigth(formats.getFontName(), formats.getTextStyle() & 0xFFFFFFFB, text, height));
        return result;
    }

    public static float paintText(Graphics2D g, float pixelsPerMillimeter, String text, TextFormats f, float x, float y) {
        Font font = f.getFont(pixelsPerMillimeter);
        g.setColor(f.getTextColor());
        g.setFont(font);
        g.drawString(text, x, y);
        float width = FontCalculator.getInstance().getWidth(font, text);
        if (f.hasTextStyle(4)) {
            float height = FontCalculator.getInstance().getHeight(font);
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(0.05f * height));
            g.draw(new Line2D.Float(x, y += 0.15f * height, x + width, y));
            g.setStroke(oldStroke);
        }
        return width;
    }
}

