/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint;

import info.bioinfweb.treegraph.graphics.positionpaint.PhylogramFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintType;
import info.bioinfweb.treegraph.graphics.positionpaint.RectangularCladogramFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.SinglePositionPaintFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.TreePainter;
import info.bioinfweb.treegraph.graphics.positionpaint.TreePositioner;
import java.util.EnumMap;

public class PositionPaintFactory {
    private static PositionPaintFactory firstInstance = null;
    private EnumMap<PositionPaintType, SinglePositionPaintFactory> factories = new EnumMap(PositionPaintType.class);

    private PositionPaintFactory() {
        this.fillFactoryList();
    }

    public static PositionPaintFactory getInstance() {
        if (firstInstance == null) {
            firstInstance = new PositionPaintFactory();
        }
        return firstInstance;
    }

    private void fillFactoryList() {
        this.factories.put(PositionPaintType.RECT_CLAD, new RectangularCladogramFactory());
        this.factories.put(PositionPaintType.PHYLOGRAM, new PhylogramFactory());
    }

    public TreePositioner getPositioner(PositionPaintType type) {
        return this.factories.get((Object)type).getPositioner();
    }

    public TreePainter getPainter(PositionPaintType type) {
        return this.factories.get((Object)type).getPainter();
    }

    public String getName(PositionPaintType type) {
        return this.factories.get((Object)type).name();
    }

    public boolean needsBrancheLengths(PositionPaintType type) {
        return this.factories.get((Object)type).needsBranchLengths();
    }

    public PositionPaintType getType(TreePositioner positioner) {
        PositionPaintType[] positionPaintTypeArray = PositionPaintType.values();
        int n = positionPaintTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PositionPaintType type = positionPaintTypeArray[n2];
            if (this.factories.get((Object)type).isPositioner(positioner)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public PositionPaintType getType(TreePainter painter) {
        PositionPaintType[] positionPaintTypeArray = PositionPaintType.values();
        int n = positionPaintTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PositionPaintType type = positionPaintTypeArray[n2];
            if (this.factories.get((Object)type).isPainter(painter)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static PositionPaintType getDefaultType() {
        return PositionPaintType.RECT_CLAD;
    }

    public String[] names() {
        String[] result = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            result[i] = this.factories.get(i).name();
            ++i;
        }
        return result;
    }

    public int size() {
        return this.factories.size();
    }
}

