/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.RectangularCladogramPositioner;
import info.bioinfweb.treegraph.graphics.positionpaint.positiondata.PositionData;

public class PhylogramPositioner
extends RectangularCladogramPositioner {
    private static PhylogramPositioner firstInstance = null;

    public PhylogramPositioner() {
        this.type = PositionPaintFactory.getInstance().getType(this);
    }

    public static PhylogramPositioner getInstance() {
        if (firstInstance == null) {
            firstInstance = new PhylogramPositioner();
        }
        return firstInstance;
    }

    @Override
    protected float rescaleNodeWidth(Node node, float width) {
        if (node.isLeaf()) {
            return width;
        }
        return node.getFormats().getLineWidth().getInMillimeters();
    }

    @Override
    protected float rescaleBranchWidth(Branch branch, float width) {
        if (branch.hasLength()) {
            if (branch.getTargetNode().hasParent() || this.document.getTree().getFormats().getShowRooted()) {
                float branchLength = (float)branch.getLength() * this.document.getTree().getFormats().getBranchLengthScale().getInMillimeters();
                if (branch.getTargetNode().hasParent()) {
                    float nodeWidth = branch.getTargetNode().getParent().getPosition(this.type).getWidth().getInMillimeters();
                    return (branchLength + nodeWidth) * this.rescalingFactorX - nodeWidth - nodeWidth;
                }
                return branchLength * this.rescalingFactorX;
            }
            return 0.0f;
        }
        return super.rescaleBranchWidth(branch, width);
    }

    @Override
    protected float calculateCornerRadiusShift(Node node, float y) {
        return 0.0f;
    }

    @Override
    protected boolean xToLow(float x, PositionData pd) {
        return false;
    }
}

