/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.export.jpeg;

import info.bioinfweb.commons.collections.ParameterMap;
import info.bioinfweb.treegraph.graphics.export.GraphicWriter;
import info.bioinfweb.treegraph.graphics.export.SVGTranscodeWriter;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;

public class JPEGWriter
extends SVGTranscodeWriter
implements GraphicWriter {
    public static final float DEFAULT_QUALITY = 0.8f;
    public static final float MIN_QUALITY = 0.01f;
    public static final float MAX_QUALITY = 1.0f;
    public static final String KEY_JPEG_QUALITY = "jpegCompression";

    public JPEGWriter() {
        super(JPEGTranscoder.class);
    }

    @Override
    protected void addTranscodingHints(Transcoder transcoder, ParameterMap writerHints) {
        super.addTranscodingHints(transcoder, writerHints);
        transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(Math.max(0.01f, Math.min(1.0f, writerHints.getFloat(KEY_JPEG_QUALITY, 0.8f)))));
    }
}

