/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.export;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.commons.collections.ParameterMap;
import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.graphics.export.AbstractGraphicWriter;
import info.bioinfweb.treegraph.graphics.export.GraphicWriter;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.TreePainter;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;

public class SVGTranscodeWriter
extends AbstractGraphicWriter
implements GraphicWriter {
    private Class<? extends Transcoder> transcoderClass = null;

    public SVGTranscodeWriter(Class<? extends Transcoder> transcoderClass) {
        this.transcoderClass = transcoderClass;
    }

    protected void addTranscodingHints(Transcoder transcoder, ParameterMap writerHints) {
    }

    @Override
    public void write(Document document, TreePainter painter, ParameterMap hints, OutputStream stream) throws Exception {
        float paintResolution;
        DistanceDimension paintDim = document.getTree().getPaintDimension(PositionPaintFactory.getInstance().getType(painter));
        float pixelsPerMillimeter = hints.getFloat("ppm", 2.8346457f);
        float width = pixelsPerMillimeter * paintDim.getWidth().getInMillimeters();
        float height = pixelsPerMillimeter * paintDim.getHeight().getInMillimeters();
        if (hints.containsKey("width") && hints.containsKey("height")) {
            width = hints.getFloat("width", width);
            height = hints.getFloat("height", height);
        }
        if (hints.getBoolean("dimensionsInPixels", false)) {
            paintResolution = width / paintDim.getWidth().getInMillimeters();
        } else {
            height *= pixelsPerMillimeter;
            paintResolution = 2.8346457f * ((width *= pixelsPerMillimeter) / paintDim.getWidth().getInPixels(2.8346457f));
        }
        SVGGeneratorContext context = SVGGeneratorContext.createDefault((org.w3c.dom.Document)GenericDOMImplementation.getDOMImplementation().createDocument("http://www.w3.org/2000/svg", "svg", null));
        context.setComment(" Generated by TreeGraph " + Main.getInstance().getVersion().toString() + " with Apache Batik SVG Generator <" + "http://treegraph.bioinfweb.info/" + ">");
        SVGGraphics2D svgGenerator = new SVGGraphics2D(context, hints.getBoolean("textAsShapes", false));
        svgGenerator.setSVGCanvasSize(new Dimension(Math2.roundUp(width), Math2.roundUp(height)));
        svgGenerator.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        painter.paintTree((Graphics2D)svgGenerator, document, null, paintResolution, hints.getBoolean("transparent", false));
        StringWriter stringWriter = new StringWriter();
        svgGenerator.stream((Writer)stringWriter);
        Transcoder t = this.transcoderClass.newInstance();
        t.addTranscodingHint(SVGAbstractTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)new Float(1.0f / pixelsPerMillimeter));
        t.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
        t.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
        this.addTranscodingHints(t, hints);
        TranscoderInput input = new TranscoderInput((Reader)new StringReader(stringWriter.getBuffer().toString()));
        TranscoderOutput output = t instanceof SVGTranscoder ? new TranscoderOutput((Writer)new OutputStreamWriter(stream, "UTF-8")) : new TranscoderOutput((OutputStream)new BufferedOutputStream(stream));
        t.transcode(input, output);
        if (output.getOutputStream() != null) {
            output.getOutputStream().close();
        }
        stream.close();
    }
}

