/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.export;

import info.bioinfweb.treegraph.graphics.export.GraphicFilter;
import info.bioinfweb.treegraph.graphics.export.GraphicFormat;
import info.bioinfweb.treegraph.graphics.export.GraphicWriter;
import info.bioinfweb.treegraph.graphics.export.GraphicsFactory;
import info.bioinfweb.treegraph.graphics.export.emf.EMFFactory;
import info.bioinfweb.treegraph.graphics.export.jpeg.JPEGFactory;
import info.bioinfweb.treegraph.graphics.export.pdf.PDFFactory;
import info.bioinfweb.treegraph.graphics.export.png.PNGFactory;
import info.bioinfweb.treegraph.graphics.export.svg.SVGFactory;
import info.bioinfweb.treegraph.graphics.export.tiff.TIFFFactory;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Set;

public class GraphicWriterFactory {
    private static GraphicWriterFactory firstInstance = null;
    private EnumMap<GraphicFormat, GraphicsFactory> factories = new EnumMap(GraphicFormat.class);

    private GraphicWriterFactory() {
        this.fillList();
    }

    public static GraphicWriterFactory getInstance() {
        if (firstInstance == null) {
            firstInstance = new GraphicWriterFactory();
        }
        return firstInstance;
    }

    private void fillList() {
        this.factories.put(GraphicFormat.PDF, new PDFFactory());
        this.factories.put(GraphicFormat.SVG, new SVGFactory());
        this.factories.put(GraphicFormat.PNG, new PNGFactory());
        this.factories.put(GraphicFormat.TIFF, new TIFFFactory());
        this.factories.put(GraphicFormat.JPEG, new JPEGFactory());
        this.factories.put(GraphicFormat.EMF, new EMFFactory());
    }

    public GraphicFormat formatByFileName(String name) {
        GraphicFormat[] graphicFormatArray = GraphicFormat.values();
        int n = graphicFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicFormat f = graphicFormatArray[n2];
            if (this.getFilter(f).validExtension(name)) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public GraphicWriter getWriter(GraphicFormat f) {
        return this.factories.get((Object)f).getWriter();
    }

    public GraphicFilter getFilter(GraphicFormat f) {
        return this.factories.get((Object)f).getFilter();
    }

    public GraphicFilter[] getAllFilters() {
        Set<GraphicFormat> set = this.factories.keySet();
        GraphicFilter[] result = new GraphicFilter[set.size()];
        Iterator<GraphicFormat> iterator = set.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            result[pos] = this.getFilter(iterator.next());
            ++pos;
        }
        return result;
    }

    public int size() {
        return this.factories.size();
    }
}

