/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.export;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.commons.collections.ParameterMap;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.graphics.export.AbstractGraphicWriter;
import info.bioinfweb.treegraph.graphics.export.GraphicWriter;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.TreePainter;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;

public abstract class FreeHEPWriter
extends AbstractGraphicWriter
implements GraphicWriter {
    protected abstract AbstractVectorGraphicsIO createGraphics(OutputStream var1, Dimension var2);

    @Override
    public void write(Document document, TreePainter painter, ParameterMap hints, OutputStream stream) {
        float paintResolution;
        DistanceDimension paintDim = document.getTree().getPaintDimension(PositionPaintFactory.getInstance().getType(painter));
        float pixelsPerMillimeter = hints.getFloat("ppm", 2.8346457f);
        float width = pixelsPerMillimeter * paintDim.getWidth().getInMillimeters();
        float height = pixelsPerMillimeter * paintDim.getHeight().getInMillimeters();
        if (hints.containsKey("width") && hints.containsKey("height")) {
            width = hints.getFloat("width", width);
            height = hints.getFloat("height", height);
        }
        if (hints.getBoolean("dimensionsInPixels", false)) {
            paintResolution = width / paintDim.getWidth().getInMillimeters();
        } else {
            height *= pixelsPerMillimeter;
            paintResolution = 2.8346457f * ((width *= pixelsPerMillimeter) / paintDim.getWidth().getInPixels(2.8346457f));
        }
        AbstractVectorGraphicsIO g = this.createGraphics(stream, new Dimension(Math2.roundUp(width), Math2.roundUp(height)));
        g.startExport();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        painter.paintTree((Graphics2D)g, document, null, paintResolution, hints.getBoolean("transparent", false));
        g.endExport();
        try {
            g.closeStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

