/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.nodebranchdata;

import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.nodebranchdata.IDElementAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.IDManager;

public class NodeBranchDataElementBackup {
    private TextElementData textElementData = null;
    private Label label = null;

    public NodeBranchDataElementBackup(NodeBranchDataAdapter adapter, Node node) {
        this.backupNode(adapter, node);
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public boolean isEmpty() {
        return this.textElementData == null && this.label == null;
    }

    private void backupIDElement(String id, Node node) {
        Object element = IDManager.getElementByID(node, id);
        if (element != null) {
            if (element instanceof Label) {
                this.label = (Label)element;
                if (this.label instanceof TextLabel) {
                    this.textElementData = ((TextLabel)this.label).getData().clone();
                }
            } else {
                this.textElementData = ((TextElementData)element).clone();
            }
        }
    }

    private void backupAdapter(NodeBranchDataAdapter adapter, Node node) {
        this.textElementData = adapter.isDecimal(node) ? new TextElementData(adapter.getDecimal(node)) : new TextElementData(adapter.getText(node));
    }

    private void backupNode(NodeBranchDataAdapter adapter, Node node) {
        if (adapter instanceof IDElementAdapter) {
            this.backupIDElement(((IDElementAdapter)adapter).getID(), node);
        } else if (!adapter.isEmpty(node)) {
            this.backupAdapter(adapter, node);
        }
    }

    public void restoreNode(NodeBranchDataAdapter adapter, Node node) {
        if (adapter instanceof IDElementAdapter) {
            IDManager.removeElementWithID(node, ((IDElementAdapter)adapter).getID());
        }
        if (this.isEmpty()) {
            adapter.delete(node);
        } else {
            if (this.hasLabel()) {
                node.getAfferentBranch().getLabels().add(this.label);
            }
            adapter.setTextElementData(node, this.textElementData);
        }
    }
}

