/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.format;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.document.format.adapters.distance.AbstractLegendAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.DistanceAdapter;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import info.bioinfweb.treegraph.document.undo.format.DistanceValuesBackup;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ScaleDistanceValuesEdit
extends DocumentEdit {
    private Node root;
    private float factor;
    private DistanceAdapter[] targetAdapters;
    private DistanceValuesBackup oldValues;

    public ScaleDistanceValuesEdit(Document document, Node root, float factor, DistanceAdapter[] targetAdapters) {
        super(document, DocumentChangeType.POSITION);
        this.root = root;
        this.factor = factor;
        this.targetAdapters = targetAdapters;
        this.oldValues = new DistanceValuesBackup(document.getTree(), root, targetAdapters);
    }

    private void setNewSubtreeValues(Node root) {
        int i = 0;
        while (i < this.targetAdapters.length) {
            this.targetAdapters[i].setDistance(this.targetAdapters[i].getDistance(root) * this.factor, root);
            ++i;
        }
        i = 0;
        while (i < root.getChildren().size()) {
            this.setNewSubtreeValues(root.getChildren().get(i));
            ++i;
        }
    }

    private void setNewDistanceValue(DistanceValue value) {
        value.setInMillimeters(value.getInMillimeters() * this.factor);
    }

    private void setNewLegendValues() {
        Legend[] legends = TreeSerializer.getLegendsInSubtree(this.getDocument().getTree(), this.root);
        int i = 0;
        while (i < this.targetAdapters.length) {
            if (this.targetAdapters[i] instanceof AbstractLegendAdapter) {
                int j = 0;
                while (j < legends.length) {
                    this.setNewDistanceValue(((AbstractLegendAdapter)this.targetAdapters[i]).getDistanceValue(legends[j].getFormats()));
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.setNewSubtreeValues(this.root);
        this.setNewLegendValues();
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.oldValues.restoreValues();
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Scale distance values";
    }
}

