/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.format;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ScaleBranchLengthsEdit
extends DocumentEdit {
    private float oldScale;
    private float newScale;

    public ScaleBranchLengthsEdit(Document document, float length) {
        super(document, DocumentChangeType.POSITION);
        this.oldScale = document.getTree().getFormats().getBranchLengthScale().getInMillimeters();
        this.newScale = ScaleBranchLengthsEdit.calculateScaleByLength(document.getTree(), length);
    }

    public static float calculateScaleByLength(Tree tree, float pathLength) {
        return (float)((double)pathLength / tree.longestPath());
    }

    @Override
    public void redo() throws CannotRedoException {
        this.getDocument().getTree().getFormats().getBranchLengthScale().setInMillimeters(this.newScale);
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.getDocument().getTree().getFormats().getBranchLengthScale().setInMillimeters(this.oldScale);
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Scale branch lengths";
    }
}

