/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.format;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ReanchorLegendEdit
extends DocumentEdit {
    private Legend legend = null;
    private String[] newAnchors = new String[2];
    private String[] oldAnchors = new String[2];

    public ReanchorLegendEdit(Document document, Legend legend, String newAnchor1, String newAnchor2) {
        super(document, DocumentChangeType.POSITION);
        this.legend = legend;
        int i = 0;
        while (i < 2) {
            this.oldAnchors[i] = legend.getFormats().getAnchorName(i);
            ++i;
        }
        this.newAnchors[0] = newAnchor1;
        this.newAnchors[1] = newAnchor2;
    }

    @Override
    public void redo() throws CannotRedoException {
        int i = 0;
        while (i < 2) {
            this.legend.getFormats().setAnchorName(i, this.newAnchors[i]);
            ++i;
        }
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        int i = 0;
        while (i < 2) {
            this.legend.getFormats().setAnchorName(i, this.oldAnchors[i]);
            ++i;
        }
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Reanchor legend";
    }
}

