/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.format;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.format.ElementFormats;
import info.bioinfweb.treegraph.document.format.LabelFormats;
import info.bioinfweb.treegraph.document.format.operate.FormatOperator;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import java.util.Vector;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class OperatorsEdit
extends DocumentEdit {
    private PaintableElement[] applyElements = null;
    private FormatOperator[] operators = null;
    private Vector<ElementFormats> changedFormats = new Vector();

    public OperatorsEdit(Document document, PaintableElement[] applyElements, FormatOperator[] operators) {
        super(document, DocumentChangeType.POSITION);
        this.applyElements = applyElements;
        this.operators = operators;
    }

    @Override
    public void redo() throws CannotRedoException {
        this.changedFormats.clear();
        int i = 0;
        while (i < this.applyElements.length) {
            ElementFormats f = this.applyElements[i].getFormats().clone();
            if (f instanceof LabelFormats) {
                ((LabelFormats)f).setOwner((Label)this.applyElements[i]);
            }
            this.changedFormats.add(f);
            int j = 0;
            while (j < this.operators.length) {
                if (this.operators[j].validTarget(this.applyElements[i].getFormats())) {
                    this.operators[j].applyTo(this.applyElements[i].getFormats());
                }
                ++j;
            }
            ++i;
        }
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        int i = 0;
        while (i < this.applyElements.length) {
            this.applyElements[i].setFormats(this.changedFormats.get(i));
            ++i;
        }
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Format element";
    }
}

