/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.format;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.format.GlobalFormats;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class GlobalFormatsEdit
extends DocumentEdit {
    GlobalFormats newFormats = null;
    GlobalFormats oldFormats = new GlobalFormats();

    public GlobalFormatsEdit(Document document, GlobalFormats newFormats) {
        super(document, DocumentChangeType.POSITION);
        this.newFormats = newFormats;
        this.oldFormats.assign(document.getTree().getFormats());
    }

    private void setFormats(GlobalFormats formats) {
        this.getDocument().getTree().getFormats().assign(formats);
    }

    @Override
    public void redo() throws CannotRedoException {
        this.setFormats(this.newFormats);
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.setFormats(this.oldFormats);
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Edit global document formats";
    }
}

