/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.format;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.format.adapters.distance.DistanceAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.AbstractNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import info.bioinfweb.treegraph.document.undo.format.DistanceValuesBackup;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class DistanceValuesByNodeBranchDataEdit
extends DocumentEdit {
    private NodeBranchDataAdapter sourceAdapter;
    private float min;
    private float factor;
    private boolean changeUndefined;
    private boolean inheritToTerminals;
    private DistanceAdapter[] targetAdapters;
    private DistanceValuesBackup oldValues;

    public DistanceValuesByNodeBranchDataEdit(Document document, NodeBranchDataAdapter sourceAdapter, float min, float max, boolean changeUndefined, boolean inheritToTerminals, DistanceAdapter[] targetAdapters) {
        super(document, DocumentChangeType.POSITION);
        this.sourceAdapter = sourceAdapter;
        this.min = min;
        this.factor = (max - min) / (float)AbstractNodeBranchDataAdapter.calculateMaxNodeData(sourceAdapter, document.getTree().getPaintStart());
        this.changeUndefined = changeUndefined;
        this.inheritToTerminals = inheritToTerminals;
        this.targetAdapters = targetAdapters;
        this.oldValues = new DistanceValuesBackup(document.getTree(), document.getTree().getPaintStart(), targetAdapters);
    }

    private void setNewValues(Node root) {
        float value = (float)this.sourceAdapter.getDecimal(root);
        if (this.inheritToTerminals && Double.isNaN(value) && root.isLeaf() && root.hasParent()) {
            int i = 0;
            while (i < this.targetAdapters.length) {
                this.targetAdapters[i].setDistance(this.targetAdapters[i].getDistance(root.getParent()), root);
                ++i;
            }
        } else {
            float distance = Float.NaN;
            if (!Double.isNaN(value)) {
                distance = this.min + this.factor * value;
            } else if (this.changeUndefined) {
                distance = this.min;
            }
            if (!Float.isNaN(distance)) {
                int i = 0;
                while (i < this.targetAdapters.length) {
                    this.targetAdapters[i].setDistance(distance, root);
                    ++i;
                }
            }
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            this.setNewValues(root.getChildren().get(i));
            ++i;
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.setNewValues(this.getDocument().getTree().getPaintStart());
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.oldValues.restoreValues();
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Set distance values by node/branch data";
    }
}

