/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.format;

import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.format.LegendFormats;
import info.bioinfweb.treegraph.document.format.adapters.distance.AbstractLegendAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.DistanceAdapter;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import java.util.List;
import java.util.Vector;

public class DistanceValuesBackup {
    private Node root;
    private Legend[] legends;
    private DistanceAdapter[] targetAdapters;
    private List<Float>[] oldTreeValues;
    private boolean storeLegendFormats = false;
    private List<LegendFormats> oldLegendFormats = new Vector<LegendFormats>();

    public DistanceValuesBackup(Tree tree, Node root, DistanceAdapter[] targetAdapters) {
        this.root = root;
        this.targetAdapters = targetAdapters;
        this.legends = TreeSerializer.getLegendsInSubtree(tree, root);
        this.saveOldTreeValues();
        this.saveOldLegendValues();
    }

    public boolean containsLegendFormats() {
        return this.storeLegendFormats;
    }

    public Legend[] getLegends() {
        return this.legends;
    }

    private void saveOldTreeValues() {
        this.oldTreeValues = new Vector[this.targetAdapters.length];
        int i = 0;
        while (i < this.oldTreeValues.length) {
            this.oldTreeValues[i] = new Vector<Float>();
            ++i;
        }
        this.saveOldSubtreeValues(this.root);
    }

    private void saveOldSubtreeValues(Node root) {
        int i = 0;
        while (i < this.targetAdapters.length) {
            this.oldTreeValues[i].add(new Float(this.targetAdapters[i].getDistance(root)));
            ++i;
        }
        i = 0;
        while (i < root.getChildren().size()) {
            this.saveOldSubtreeValues(root.getChildren().get(i));
            ++i;
        }
    }

    private void saveOldLegendValues() {
        int i = 0;
        while (i < this.targetAdapters.length) {
            if (this.targetAdapters[i] instanceof AbstractLegendAdapter) {
                this.storeLegendFormats = true;
                break;
            }
            ++i;
        }
        if (this.storeLegendFormats) {
            i = 0;
            while (i < this.legends.length) {
                this.oldLegendFormats.add(this.legends[i].getFormats().clone());
                ++i;
            }
        }
    }

    public void restoreValues() {
        this.restoreSubtreeValues(this.root, 0);
        if (this.storeLegendFormats) {
            int i = 0;
            while (i < this.legends.length) {
                this.legends[i].getFormats().assign(this.oldLegendFormats.get(i));
                ++i;
            }
        }
    }

    private int restoreSubtreeValues(Node root, int index) {
        int i = 0;
        while (i < this.targetAdapters.length) {
            this.targetAdapters[i].setDistance(this.oldTreeValues[i].get(index).floatValue(), root);
            ++i;
        }
        ++index;
        i = 0;
        while (i < root.getChildren().size()) {
            index = this.restoreSubtreeValues(root.getChildren().get(i), index);
            ++i;
        }
        return index;
    }
}

