/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.format;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.format.adapters.color.ColorAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.AbstractNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import java.awt.Color;
import java.util.Vector;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ColorsByNodeBranchDataEdit
extends DocumentEdit {
    private NodeBranchDataAdapter sourceAdapter;
    private Color min;
    double redFactor;
    double greenFactor;
    double blueFactor;
    private boolean changeUndefined;
    private boolean inheritToTerminals;
    private ColorAdapter[] targetAdapters;
    private Vector<Color>[] oldColors;

    public ColorsByNodeBranchDataEdit(Document document, NodeBranchDataAdapter sourceAdapter, Color min, Color max, boolean changeUndefined, boolean inheritToTerminals, ColorAdapter[] targetAdapters) {
        super(document, DocumentChangeType.NEUTRAL);
        this.sourceAdapter = sourceAdapter;
        this.min = min;
        this.changeUndefined = changeUndefined;
        this.inheritToTerminals = inheritToTerminals;
        this.targetAdapters = targetAdapters;
        double maxValue = AbstractNodeBranchDataAdapter.calculateMaxNodeData(sourceAdapter, document.getTree().getPaintStart());
        this.redFactor = (double)(max.getRed() - min.getRed()) / maxValue;
        this.greenFactor = (double)(max.getGreen() - min.getGreen()) / maxValue;
        this.blueFactor = (double)(max.getBlue() - min.getBlue()) / maxValue;
        this.saveOldColors();
    }

    private void saveOldColors() {
        this.oldColors = new Vector[this.targetAdapters.length];
        int i = 0;
        while (i < this.oldColors.length) {
            this.oldColors[i] = new Vector();
            ++i;
        }
        this.saveOldSubtreeColors(this.getDocument().getTree().getPaintStart());
    }

    private void saveOldSubtreeColors(Node root) {
        int i = 0;
        while (i < this.targetAdapters.length) {
            this.oldColors[i].add(this.targetAdapters[i].getColor(root));
            ++i;
        }
        i = 0;
        while (i < root.getChildren().size()) {
            this.saveOldSubtreeColors(root.getChildren().get(i));
            ++i;
        }
    }

    private void setNewColors(Node root) {
        double value = this.sourceAdapter.getDecimal(root);
        if (this.inheritToTerminals && Double.isNaN(value) && root.isLeaf() && root.hasParent()) {
            int i = 0;
            while (i < this.targetAdapters.length) {
                this.targetAdapters[i].setColor(this.targetAdapters[i].getColor(root.getParent()), root);
                ++i;
            }
        } else {
            Color color = null;
            if (!Double.isNaN(value)) {
                color = new Color(this.min.getRed() + (int)Math.round(this.redFactor * value), this.min.getGreen() + (int)Math.round(this.greenFactor * value), this.min.getBlue() + (int)Math.round(this.blueFactor * value));
            } else if (this.changeUndefined) {
                color = this.min;
            }
            if (color != null) {
                int i = 0;
                while (i < this.targetAdapters.length) {
                    this.targetAdapters[i].setColor(color, root);
                    ++i;
                }
            }
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            this.setNewColors(root.getChildren().get(i));
            ++i;
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.setNewColors(this.getDocument().getTree().getPaintStart());
        super.redo();
    }

    private int setOldColors(Node root, int index) {
        int i = 0;
        while (i < this.targetAdapters.length) {
            this.targetAdapters[i].setColor(this.oldColors[i].get(index), root);
            ++i;
        }
        ++index;
        i = 0;
        while (i < root.getChildren().size()) {
            index = this.setOldColors(root.getChildren().get(i), index);
            ++i;
        }
        return index;
    }

    @Override
    public void undo() throws CannotUndoException {
        this.setOldColors(this.getDocument().getTree().getPaintStart(), 0);
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Set colors by node/branch data";
    }
}

