/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.format;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.format.LabelFormats;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class AutoPositionLabelsEdit
extends DocumentEdit {
    public static final double LABEL_BLOCK_ASPECT_RATIO = 2.0;
    public static final int LINE_POSITION_STEP = 10;
    private Branch[] branches;
    private List<String> ids;
    private boolean equalSupportConflictPosition;
    private Vector<LabelFormats>[] oldFormats;

    public AutoPositionLabelsEdit(Document document, Branch[] branches, boolean equalSupportConflictPosition) {
        super(document, DocumentChangeType.POSITION);
        this.branches = branches;
        this.equalSupportConflictPosition = equalSupportConflictPosition;
        this.ids = AutoPositionLabelsEdit.readIDs(document.getTree().getPaintStart(), equalSupportConflictPosition);
        this.backupFormats();
    }

    private static String conflictIDBySupportID(String id) {
        return id.replace("Support", "Conflict");
    }

    private static List<String> readIDs(Node root, boolean equalSupportConflictPosition) {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(IDManager.getLabelIDs(root, Label.class)));
        Collections.sort(result);
        if (equalSupportConflictPosition) {
            ArrayList<String> supportIDs = new ArrayList<String>();
            for (String id : result) {
                if (!id.endsWith("Support")) continue;
                supportIDs.add(id);
            }
            for (String supportID : supportIDs) {
                result.remove(AutoPositionLabelsEdit.conflictIDBySupportID(supportID));
            }
        }
        return result;
    }

    private void backupFormats() {
        this.oldFormats = new Vector[this.ids.size()];
        int i = 0;
        while (i < this.oldFormats.length) {
            this.oldFormats[i] = new Vector();
            ++i;
        }
        i = 0;
        while (i < this.branches.length) {
            int j = 0;
            while (j < this.ids.size()) {
                Label l = this.branches[i].getLabels().get(this.ids.get(j));
                if (l != null) {
                    this.oldFormats[j].add(l.getFormats().clone());
                } else {
                    this.oldFormats[j].add(null);
                }
                ++j;
            }
            ++i;
        }
    }

    private void restoreFormats() {
        int i = 0;
        while (i < this.branches.length) {
            int j = 0;
            while (j < this.ids.size()) {
                Label l = this.branches[i].getLabels().get(this.ids.get(j));
                if (l != null) {
                    l.getFormats().assignLabelFormats(this.oldFormats[j].get(i));
                }
                ++j;
            }
            ++i;
        }
    }

    private static Label getLabel(Branch branch, String id) {
        Label result = branch.getLabels().get(id);
        if (result == null) {
            result = branch.getLabels().get(AutoPositionLabelsEdit.conflictIDBySupportID(id));
        }
        return result;
    }

    private static void position(Branch branch, List<String> ids) {
        LabelFormats f;
        Label l;
        int labelsPerBlock = ids.size() / 2 + ids.size() % 2;
        int labelsPerLine = Math.round((float)labelsPerBlock / (float)Math.sqrt((double)labelsPerBlock / 2.0));
        int pos = 0;
        while (pos < labelsPerBlock) {
            l = AutoPositionLabelsEdit.getLabel(branch, ids.get(pos));
            if (l != null) {
                f = l.getFormats();
                f.setAbove(true);
                f.setLineNumber(pos / labelsPerLine);
                f.setLinePosition(pos % labelsPerLine * 10);
            }
            ++pos;
        }
        while (pos < ids.size()) {
            l = AutoPositionLabelsEdit.getLabel(branch, ids.get(pos));
            if (l != null) {
                f = l.getFormats();
                f.setAbove(false);
                int localPos = pos - labelsPerBlock;
                f.setLineNumber(localPos / labelsPerLine);
                f.setLinePosition(localPos % labelsPerLine * 10);
            }
            ++pos;
        }
    }

    public static void position(Node root) {
        List<String> ids = AutoPositionLabelsEdit.readIDs(root, false);
        Branch[] branches = (Branch[])TreeSerializer.getElementsInSubtree((Node)root, (NodeType)NodeType.BOTH, Branch.class);
        int i = 0;
        while (i < branches.length) {
            AutoPositionLabelsEdit.position(branches[i], ids);
            ++i;
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        int i = 0;
        while (i < this.branches.length) {
            AutoPositionLabelsEdit.position(this.branches[i], this.ids);
            ++i;
        }
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.restoreFormats();
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Automatically position labels";
    }
}

