/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.file.importtable;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import info.bioinfweb.treegraph.document.undo.WarningMessageEdit;
import info.bioinfweb.treegraph.document.undo.file.importtable.ImportTableData;
import info.bioinfweb.treegraph.document.undo.file.importtable.ImportTableParameters;
import info.bioinfweb.treegraph.document.undo.nodebranchdata.NodeBranchDataColumnBackup;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ImportTableEdit
extends DocumentEdit
implements WarningMessageEdit {
    private ImportTableParameters parameters;
    private ImportTableData data;
    private List<NodeBranchDataColumnBackup> backups;
    private Set<String> keysNotInTree = new TreeSet<String>();

    public ImportTableEdit(Document document, ImportTableParameters parameters, ImportTableData data) {
        super(document, DocumentChangeType.TOPOLOGICAL_BY_RENAMING);
        this.parameters = parameters;
        this.data = data;
        this.backups = this.createBackups(data.getKeyColumnIndex());
    }

    public boolean isAllKeysFound() {
        return this.keysNotInTree.isEmpty();
    }

    public Set<String> getKeysNotInTree() {
        return this.keysNotInTree;
    }

    @Override
    public String getWarningText() {
        return "The following entries in the key column of the table could not be found in the specified\nnode/branch data column of the tree:\n\n" + DocumentAction.createElementList(this.getKeysNotInTree(), true) + "\n\n" + "The cells in the according lines have not been imported.\n(" + "Note that the parameter settings (e.g. whitespace treatment, case sensitivity)\ninfluences if two entries are considered equal." + ")";
    }

    @Override
    public boolean hasWarnings() {
        return !this.isAllKeysFound();
    }

    private List<NodeBranchDataColumnBackup> createBackups(int keyColumnIndex) {
        ArrayList<NodeBranchDataColumnBackup> result = new ArrayList<NodeBranchDataColumnBackup>(this.parameters.getImportAdapters().length - 1);
        int i = 0;
        while (i < this.parameters.getImportAdapters().length) {
            if (i != keyColumnIndex) {
                result.add(new NodeBranchDataColumnBackup(this.parameters.getImportAdapters()[i], this.getDocument().getTree().getPaintStart()));
            }
            ++i;
        }
        return result;
    }

    private void addNodesByData(Collection<Node> result, Node root, TextElementData data) {
        TextElementData rootData = this.parameters.getKeyAdapter().toTextElementData(root);
        if (rootData.equals(data) || this.parameters.createEditedValue(rootData.toString()).equals(data)) {
            result.add(root);
        }
        Iterator<Node> iterator = root.getChildren().iterator();
        while (iterator.hasNext()) {
            this.addNodesByData(result, iterator.next(), data);
        }
    }

    private Collection<Node> getNodesByData(TextElementData data) {
        ArrayList<Node> result = new ArrayList<Node>();
        this.addNodesByData(result, this.getDocument().getTree().getPaintStart(), data);
        return result;
    }

    private void importData() {
        this.keysNotInTree.clear();
        if (this.parameters.getImportAdapters().length == this.data.columnCount()) {
            for (TextElementData key : this.data.keySet()) {
                Collection<Node> nodes = this.getNodesByData(key);
                if (nodes.size() > 0) {
                    int row = this.data.getRowByKey(key);
                    for (Node currentNode : nodes) {
                        int column = 0;
                        while (column < this.parameters.getImportAdapters().length) {
                            if (column != this.data.getKeyColumnIndex()) {
                                String value = this.data.getTableValue(column, row);
                                if (this.parameters.isParseNumericValues() && Math2.isDecimal(value)) {
                                    this.parameters.getImportAdapters()[column].setDecimal(currentNode, Math2.parseDouble(value));
                                } else {
                                    this.parameters.getImportAdapters()[column].setText(currentNode, value);
                                }
                            }
                            ++column;
                        }
                    }
                    continue;
                }
                this.keysNotInTree.add(this.data.getKeyColumnEntry(this.data.getRowByKey(key)));
            }
        } else {
            throw new IllegalArgumentException("The number of adapters (" + this.parameters.getImportAdapters().length + ") and columns (" + this.data.columnCount() + ") do not match.");
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.importData();
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        for (NodeBranchDataColumnBackup backup : this.backups) {
            backup.restore(this.getDocument().getTree().getPaintStart());
        }
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Import table";
    }
}

