/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.file.importtable;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.commons.io.TableReader;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.undo.CompareTextElementDataParameters;
import info.bioinfweb.treegraph.document.undo.file.importtable.DuplicateKeyException;
import info.bioinfweb.treegraph.document.undo.file.importtable.ImportTableParameters;
import info.bioinfweb.treegraph.document.undo.file.importtable.InsufficientTableSizeException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ImportTableData {
    private String[][] data;
    private int rowOffset = 0;
    private boolean containsHeadings = false;
    private int keyColumn = -1;
    private Map<TextElementData, Integer> keyToLineMap = new TreeMap<TextElementData, Integer>();

    public ImportTableData(ImportTableParameters parameters) throws IOException, DuplicateKeyException, InsufficientTableSizeException {
        this.data = TableReader.readTable(parameters.getTableFile(), parameters.getColumnSeparator());
        this.rowOffset = parameters.getLinesToSkip();
        this.containsHeadings = parameters.isHeadingContained();
        if (this.containsHeadings) {
            ++this.rowOffset;
        }
        if (this.columnCount() <= 1 || this.rowCount() == 0) {
            throw new InsufficientTableSizeException(this.columnCount(), this.rowCount());
        }
    }

    public void processKeyColumn(int columnIndex, CompareTextElementDataParameters parameters) throws DuplicateKeyException {
        if (Math2.isBetween(columnIndex, 0, this.columnCount() - 1)) {
            this.keyColumn = columnIndex;
            this.keyToLineMap.clear();
            DuplicateKeyException exception = null;
            int rowIndex = 0;
            while (rowIndex < this.rowCount()) {
                TextElementData key = parameters.createEditedValue(this.data[columnIndex][rowIndex + this.rowOffset]);
                if (this.keyToLineMap.containsKey(key)) {
                    if (exception == null) {
                        exception = new DuplicateKeyException();
                    }
                    exception.addKey(key.toString());
                } else {
                    this.keyToLineMap.put(key, rowIndex);
                }
                ++rowIndex;
            }
            if (exception != null) {
                throw exception;
            }
        } else {
            throw new IndexOutOfBoundsException("The column index (" + columnIndex + ") must be between 0 and " + (this.columnCount() - 1) + ".");
        }
    }

    public int getKeyColumnIndex() {
        return this.keyColumn;
    }

    public boolean containsHeadings() {
        return this.containsHeadings;
    }

    public int getRowByKey(TextElementData key) {
        Integer result = this.keyToLineMap.get(key);
        if (result == null) {
            return -1;
        }
        return result;
    }

    public Set<TextElementData> keySet() {
        return this.keyToLineMap.keySet();
    }

    public String getTableValue(int column, int row) {
        if (Math2.isBetween(column, 0, this.columnCount() - 1) && Math2.isBetween(row, 0, this.rowCount() - 1)) {
            return this.data[column][row + this.rowOffset];
        }
        throw new IllegalArgumentException("Invalid column " + column + " and/or invalid row " + row + ".");
    }

    public String getKeyColumnEntry(int row) {
        if (this.keyColumn == -1) {
            throw new IllegalStateException("No key column is currently defined.");
        }
        if (!Math2.isBetween(row, 0, this.rowCount() - 1)) {
            throw new IllegalArgumentException("Invalid row index " + row + ".");
        }
        return this.data[this.keyColumn][row + this.rowOffset];
    }

    public String getHeading(int column) {
        if (this.containsHeadings()) {
            if (Math2.isBetween(column, 0, this.columnCount() - 1)) {
                return this.data[column][this.rowOffset - 1];
            }
            throw new IllegalArgumentException("Invalid column index " + column + ".");
        }
        return "";
    }

    public int columnCount() {
        return this.data.length;
    }

    public int rowCount() {
        if (this.data.length > 0) {
            return this.data[0].length - this.rowOffset;
        }
        return 0;
    }
}

