/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.file.ancestralstate;

import info.bioinfweb.commons.progress.ProgressMonitor;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PieChartLabel;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.io.ancestralstate.AncestralStateData;
import info.bioinfweb.treegraph.document.nodebranchdata.IDElementAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.VoidNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.topologicalcalculation.LeafSet;
import info.bioinfweb.treegraph.document.topologicalcalculation.NodeInfo;
import info.bioinfweb.treegraph.document.undo.AbstractTopologicalCalculationEdit;
import info.bioinfweb.treegraph.document.undo.WarningMessageEdit;
import info.bioinfweb.treegraph.document.undo.file.ancestralstate.AncestralStateImportParameters;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ImportBayesTraitsDataEdit
extends AbstractTopologicalCalculationEdit
implements WarningMessageEdit {
    private AncestralStateImportParameters parameters;
    private Map<Node, LeafSet> internalNodes = new HashMap<Node, LeafSet>();
    private Set<String> terminalNodesNotFound = new TreeSet<String>();
    private Set<String> internalDataNotAdded = new TreeSet<String>();
    private Set<String> nodeDataNotFound = new TreeSet<String>();
    private ProgressMonitor progressMonitor;

    public ImportBayesTraitsDataEdit(Document document, AncestralStateImportParameters parameters, ProgressMonitor progressMonitor) {
        super(document, DocumentChangeType.TOPOLOGICAL_BY_RENAMING, parameters.getKeyAdapter(), true);
        this.parameters = parameters;
        this.progressMonitor = progressMonitor;
    }

    public ImportBayesTraitsDataEdit(Document document, AncestralStateImportParameters parameters) {
        this(document, parameters, null);
    }

    public boolean isAllTerminalsFound() {
        return this.terminalNodesNotFound.isEmpty();
    }

    public boolean isAllInternalsFound() {
        return this.internalDataNotAdded.isEmpty();
    }

    public boolean isAllNodeDataFound() {
        return this.nodeDataNotFound.isEmpty();
    }

    public Set<String> getTerminalNodesNotFound() {
        return this.terminalNodesNotFound;
    }

    public Set<String> getInternalDataNotAdded() {
        return this.internalDataNotAdded;
    }

    public Set<String> getNodeDataNotFound() {
        return this.nodeDataNotFound;
    }

    @Override
    public String getWarningText() {
        StringBuffer message = new StringBuffer();
        if (this.hasTerminalsNotFoundWarnings()) {
            message.append("The following MRCA/node definitions could not be reconstructed, because one or more\n");
            message.append("of the referenced terminal nodes is not contained in the current tree document:\n\n");
            message.append(DocumentAction.createElementList(this.terminalNodesNotFound, true));
        }
        if (this.hasInternalDataNotAddedWarnings()) {
            message.append("More than one BayesTraits node/MRCA definitions were found for the following node(s). \n");
            message.append("(Only the data of the MRCA definition(s) containing the highest number of terminal taxa were imported.\n");
            Iterator<String> iterator = this.internalDataNotAdded.iterator();
            if (!(this.parameters.getInternalNodeNamesAdapter() instanceof VoidNodeBranchDataAdapter)) {
                message.append("The names of the imported Node/MRCA definitions are listed below.)\n\n");
                while (iterator.hasNext()) {
                    message.append("\"" + this.parameters.getInternalNodeNamesAdapter().getText(this.getDocument().getTree().getNodeByUniqueName(iterator.next())) + "\"" + "\n");
                }
            } else {
                message.append("Unique node names of the affected nodes are listed below.)\n\n");
                message.append(DocumentAction.createElementList(this.internalDataNotAdded, true));
            }
        }
        if (this.hasNodeDataNotFoundWarnings()) {
            message.append("No probability data for the following internal nodes could be found:\n\n");
            message.append(DocumentAction.createElementList(this.nodeDataNotFound, true));
            message.append("\nMake sure the BayesTraits analysis worked correctly.");
        }
        return message.toString();
    }

    @Override
    public boolean hasWarnings() {
        return this.hasTerminalsNotFoundWarnings() || this.hasInternalDataNotAddedWarnings() || this.hasNodeDataNotFoundWarnings();
    }

    public boolean hasTerminalsNotFoundWarnings() {
        return !this.isAllTerminalsFound();
    }

    public boolean hasInternalDataNotAddedWarnings() {
        return !this.isAllInternalsFound();
    }

    public boolean hasNodeDataNotFoundWarnings() {
        return !this.isAllNodeDataFound();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node findReconstructedNode(AncestralStateData data) {
        LeafSet leafSet = null;
        leafSet = this.getTopologicalCalculator().isProcessRooted() ? new LeafSet(this.getTopologicalCalculator().getLeafCount() + 1) : new LeafSet(this.getTopologicalCalculator().getLeafCount());
        if (data.getName().equals("Root")) {
            int i = 0;
            while (i < leafSet.size()) {
                leafSet.setChild(i, true);
                ++i;
            }
        } else {
            Iterator<String> iterator = data.getLeafNames().iterator();
            while (iterator.hasNext()) {
                int index = this.getTopologicalCalculator().getLeafIndex(iterator.next());
                if (index != -1) {
                    leafSet.setChild(index, true);
                    continue;
                }
                this.terminalNodesNotFound.add(data.getName());
                return null;
            }
        }
        List<NodeInfo> results = this.getTopologicalCalculator().findNodeWithAllLeaves(this.getDocument().getTree(), leafSet);
        Node result = null;
        if (!results.isEmpty()) {
            result = results.get(0).getNode();
        }
        if (this.internalNodes.keySet().contains(result)) {
            this.internalDataNotAdded.add(result.getUniqueName());
            if (this.internalNodes.get(result).size() >= leafSet.size()) return null;
            this.internalNodes.put(result, leafSet);
            return result;
        } else {
            this.internalNodes.put(result, leafSet);
        }
        return result;
    }

    @Override
    public String getPresentationName() {
        return "Import BayesTraits log data";
    }

    @Override
    protected void performRedo() {
        this.getTopologicalCalculator().addLeafSets(this.getDocument().getTree().getPaintStart(), this.parameters.getKeyAdapter());
        double progressInterval = 1.0 / (double)this.parameters.getData().size();
        for (String internalNodeName : this.parameters.getData().keySet()) {
            Node internalNode = this.findReconstructedNode(this.parameters.getData().get(internalNodeName));
            if (internalNode != null) {
                Branch branch = internalNode.getAfferentBranch();
                int importAdapterIndex = 0;
                Iterator<String> characterIterator = this.parameters.getData().get(internalNodeName).getSiteIterator();
                int characterIndex = 0;
                this.parameters.getInternalNodeNamesAdapter().setText(internalNode, internalNodeName);
                while (characterIterator.hasNext()) {
                    String labelID = this.parameters.getPieChartLabelIDs()[characterIndex];
                    PieChartLabel label = null;
                    if (labelID != null) {
                        label = new PieChartLabel(branch.getLabels());
                        label.setID(this.parameters.getPieChartLabelIDs()[characterIndex]);
                    }
                    String siteKey = characterIterator.next();
                    Iterator<String> stateIterator = this.parameters.getData().get(internalNodeName).getKeyIterator(siteKey);
                    while (stateIterator.hasNext()) {
                        double probability;
                        if (labelID != null) {
                            label.getSectionDataList().add(new PieChartLabel.SectionData(((IDElementAdapter)this.parameters.getImportAdapters()[importAdapterIndex]).getID(), ""));
                        }
                        if (!Double.isNaN(probability = this.parameters.getData().get(internalNodeName).getProbability(siteKey, stateIterator.next()))) {
                            this.parameters.getImportAdapters()[importAdapterIndex].setDecimal(internalNode, probability);
                        } else {
                            this.nodeDataNotFound.add(this.parameters.getData().get(internalNodeName).getName());
                            this.parameters.getImportAdapters()[importAdapterIndex].setText(internalNode, "--");
                        }
                        ++importAdapterIndex;
                    }
                    if (labelID != null) {
                        internalNode.getAfferentBranch().getLabels().add(label);
                    }
                    ++characterIndex;
                }
            }
            if (this.progressMonitor == null) continue;
            this.progressMonitor.addToProgressValue(progressInterval, "Writing data to \"" + internalNodeName + "\".");
        }
    }
}

