/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.file;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.io.DocumentIterator;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.TextElementDataAdapter;
import info.bioinfweb.treegraph.document.topologicalcalculation.LeafSet;
import info.bioinfweb.treegraph.document.undo.AbstractTopologicalCalculationEdit;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class NodeSupportEdit
extends AbstractTopologicalCalculationEdit {
    private double treeCounter = 0.0;
    private double normalisationBorder = 0.0;
    private DocumentIterator documentIterator = null;
    private NodeBranchDataAdapter supportValuesAdapter = null;
    private TextElementDataAdapter sourceLeafsAdapter = NodeNameAdapter.getSharedInstance();
    private HashMap<LeafSet, Node> hashMap = new HashMap();

    public NodeSupportEdit(Document document, TextElementDataAdapter terminalsAdapter, NodeBranchDataAdapter supportValuesAdapter, TextElementDataAdapter sourceLeafsAdapter, boolean processRooted, DocumentIterator documentIterator, double normalisationBorder) {
        super(document, DocumentChangeType.TOPOLOGICAL_BY_RENAMING, terminalsAdapter, processRooted);
        this.supportValuesAdapter = supportValuesAdapter;
        this.documentIterator = documentIterator;
        this.normalisationBorder = normalisationBorder;
    }

    @Override
    public String getPresentationName() {
        return "Determine node frequency";
    }

    @Override
    protected void performRedo() {
        this.getTopologicalCalculator().addLeafSets(this.getDocument().getTree().getPaintStart(), this.getTargetLeavesAdapter());
        this.createHashmap(this.getDocument().getTree().getPaintStart());
        this.initialiseSupportValues(this.getDocument().getTree().getPaintStart());
        try {
            Document result = this.documentIterator.next();
            while (result != null) {
                this.treeCounter += 1.0;
                this.countSimilarNodes(result.getTree().getPaintStart());
                result = this.documentIterator.next();
            }
            if (this.normalisationBorder != -1.0) {
                this.normalisationValues(this.getDocument().getTree().getPaintStart());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "The following error occured: " + e.getLocalizedMessage(), "Error", 0);
            e.printStackTrace();
            this.undo();
        }
    }

    public void initialiseSupportValues(Node node) {
        if (!node.isLeaf()) {
            this.supportValuesAdapter.setDecimal(node, 0.0);
            int i = 0;
            while (i < node.getChildren().size()) {
                this.initialiseSupportValues(node.getChildren().get(i));
                ++i;
            }
        }
    }

    public void normalisationValues(Node node) {
        if (!node.isLeaf()) {
            this.supportValuesAdapter.setDecimal(node, this.supportValuesAdapter.getDecimal(node) / this.treeCounter * this.normalisationBorder);
            int i = 0;
            while (i < node.getChildren().size()) {
                this.normalisationValues(node.getChildren().get(i));
                ++i;
            }
        }
    }

    public void createHashmap(Node root) {
        if (!root.isLeaf()) {
            LeafSet field = this.getTopologicalCalculator().getLeafSet(root);
            this.hashMap.put(field, root);
            int i = 0;
            while (i < root.getChildren().size()) {
                Node child = root.getChildren().get(i);
                this.createHashmap(child);
                ++i;
            }
        }
    }

    private void counter(Node node) {
        this.supportValuesAdapter.setDecimal(node, this.supportValuesAdapter.getDecimal(node) + 1.0);
    }

    private void countSimilarNodes(Node root) {
        this.getTopologicalCalculator().addLeafSets(root, this.sourceLeafsAdapter);
        if (!root.isLeaf()) {
            Node corresponding = this.hashMap.get(this.getTopologicalCalculator().getLeafSet(root));
            if (corresponding != null) {
                this.counter(corresponding);
            } else {
                corresponding = this.hashMap.get(this.getTopologicalCalculator().getLeafSet(root).complement());
                if (corresponding != null) {
                    this.counter(corresponding);
                }
            }
            int i = 0;
            while (i < root.getChildren().size()) {
                this.countSimilarNodes(root.getChildren().get(i));
                ++i;
            }
        }
    }
}

