/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.file;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.TextElementDataAdapter;
import info.bioinfweb.treegraph.document.tools.TextElementDataAsStringIterator;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.document.topologicalcalculation.LeafSet;
import info.bioinfweb.treegraph.document.topologicalcalculation.NodeInfo;
import info.bioinfweb.treegraph.document.undo.AbstractTopologicalCalculationEdit;
import info.bioinfweb.treegraph.document.undo.WarningMessageEdit;
import info.bioinfweb.treegraph.document.undo.file.AddSupportValuesParameters;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AddSupportValuesEdit
extends AbstractTopologicalCalculationEdit
implements WarningMessageEdit {
    public static final String SUPPORT_NAME = "Support";
    public static final String CONFLICT_NAME = "Conflict";
    public static final DecimalFormat SUPPORT_DECIMAL_FORMAT = new DecimalFormat("#.#######");
    public static final DecimalFormat CONFLICT_DECIMAL_FORMAT = new DecimalFormat("[#.#######];[-#.#######]");
    private Document sourceDocument = null;
    private NodeBranchDataAdapter sourceSupportAdapter = null;
    private NodeBranchDataAdapter sourceLeavesAdapter = null;
    private TextElementDataAdapter targetSupportAdapter = null;
    private TextElementDataAdapter targetConflictAdapter = null;
    private boolean parseNumericValues;
    private String warningMessage = null;

    public AddSupportValuesEdit(Document targetDocument, AddSupportValuesParameters parameters) {
        super(targetDocument, DocumentChangeType.TOPOLOGICAL_BY_RENAMING, parameters.getTerminalsAdapter(), parameters.isRooted());
        this.sourceDocument = parameters.getSourceDocument();
        this.sourceSupportAdapter = parameters.getSourceSupportColumn();
        this.sourceLeavesAdapter = parameters.getSourceLeavesColumn();
        this.parseNumericValues = parameters.isParseNumericValues();
        this.targetSupportAdapter = parameters.getTargetType().createAdapterInstance(String.valueOf(parameters.getIDPrefix()) + SUPPORT_NAME, SUPPORT_DECIMAL_FORMAT);
        this.targetConflictAdapter = parameters.getTargetType().createAdapterInstance(String.valueOf(parameters.getIDPrefix()) + CONFLICT_NAME, CONFLICT_DECIMAL_FORMAT);
        this.getTopologicalCalculator().filterIndexMapBySubtree(this.sourceDocument.getTree().getPaintStart(), this.sourceLeavesAdapter);
    }

    @Override
    protected void performRedo() {
        this.getTopologicalCalculator().addLeafSets(this.sourceDocument.getTree().getPaintStart(), this.sourceLeavesAdapter);
        this.getTopologicalCalculator().addLeafSets(this.getDocument().getTree().getPaintStart(), this.getTargetLeavesAdapter());
        this.processSubtree(this.getDocument().getTree().getPaintStart());
        this.warningMessage = this.createWarningMessage();
    }

    private boolean hasTwoOrMoreSharedTerminalsOnBothSides(Node node) {
        LeafSet leafSet = this.getTopologicalCalculator().getLeafSet(node);
        return leafSet.childCount() >= 2 && leafSet.complement().childCount() >= 2;
    }

    private void processSubtree(Node targetRoot) {
        LeafSet leafSet = this.getTopologicalCalculator().getLeafSet(targetRoot);
        if (this.hasTwoOrMoreSharedTerminalsOnBothSides(targetRoot)) {
            List<NodeInfo> bestSourceNodes = this.getTopologicalCalculator().findNodeWithAllLeaves(this.sourceDocument.getTree(), leafSet);
            if (bestSourceNodes.get(0).getAdditionalCount() == 0) {
                double importedValue = Double.NaN;
                Iterator<NodeInfo> iterator = bestSourceNodes.iterator();
                while (Double.isNaN(importedValue) && iterator.hasNext()) {
                    importedValue = this.sourceSupportAdapter.getNumericValue(iterator.next().getNode(), this.parseNumericValues);
                }
                if (!Double.isNaN(importedValue)) {
                    this.targetSupportAdapter.setDecimal(targetRoot, importedValue);
                }
            } else {
                Node conflict = this.getTopologicalCalculator().findHighestConflict(bestSourceNodes.get(0).getNode(), leafSet, this.sourceSupportAdapter, this.parseNumericValues);
                if (conflict != null && this.hasTwoOrMoreSharedTerminalsOnBothSides(conflict)) {
                    this.targetConflictAdapter.setDecimal(targetRoot, this.sourceSupportAdapter.getNumericValue(conflict, this.parseNumericValues));
                }
            }
        }
        for (Node child : targetRoot.getChildren()) {
            this.processSubtree(child);
        }
    }

    @Override
    public String getPresentationName() {
        return "Add support values from another tree";
    }

    @Override
    public String getWarningText() {
        return this.warningMessage;
    }

    @Override
    public boolean hasWarnings() {
        return this.warningMessage != null;
    }

    private String createWarningMessage() {
        Set targetLeaves = TreeSerializer.addTextElementDataCopiesFromSubtree(new HashSet(), this.getDocument().getTree().getPaintStart(), NodeType.LEAVES, this.targetLeavesAdapter, null);
        Set remainingSourceLeaves = TreeSerializer.addTextElementDataCopiesFromSubtree(new HashSet(), this.sourceDocument.getTree().getPaintStart(), NodeType.LEAVES, this.sourceLeavesAdapter, targetLeaves);
        if (remainingSourceLeaves.isEmpty()) {
            return null;
        }
        return "There were no respective terminal nodes in the target document for the following terminal nodes from the source document found:\n\n" + DocumentAction.createElementList(new TextElementDataAsStringIterator(remainingSourceLeaves.iterator()), remainingSourceLeaves.size(), true) + "\n\nConsequently, some support values may not have been imported from the source tree (which may have been desired).\n" + "(Note that matching also may have failed because the specified leaf node/branch data columns for the source or " + "target document were not correct.)";
    }
}

