/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.vararg;

import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.edit.CalculateColumnEdit;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.IDFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.vararg.VarArgFunction;
import java.util.Stack;
import org.nfunk.jep.ParseException;

public class WholeColumnFunction
extends IDFunction {
    private VarArgFunction implementingVersion;

    public WholeColumnFunction(CalculateColumnEdit edit, VarArgFunction implementingVersion) {
        super(edit);
        this.implementingVersion = implementingVersion;
    }

    @Override
    public String getName() {
        return String.valueOf(this.implementingVersion.getName()) + "OfLines";
    }

    public boolean checkNumberOfParameters(int n) {
        return n == 1;
    }

    public int getNumberOfParameters() {
        return 1;
    }

    private void addSubtreeToStack(Node root, NodeBranchDataAdapter adapter, Stack stack) {
        Object value = this.getEdit().getValue(root, adapter);
        if (value != null) {
            stack.push(value);
        }
        for (Node child : root.getChildren()) {
            this.addSubtreeToStack(child, adapter, stack);
        }
    }

    private Object calculate(NodeBranchDataAdapter adapter) throws ParseException {
        Stack stack = new Stack();
        this.addSubtreeToStack(this.getEdit().getDocument().getTree().getPaintStart(), adapter, stack);
        this.implementingVersion.setCurNumberOfParameters(stack.size());
        this.implementingVersion.run(stack);
        return stack.pop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(Stack stack) throws ParseException {
        Object idValue = stack.pop();
        if (idValue instanceof String) {
            NodeBranchDataAdapter adapter = this.getEdit().getAdapterByID((String)idValue);
            if (adapter != null) {
                stack.push(this.calculate(adapter));
                return;
            } else {
                this.getEdit().throwUndefinedIDException((String)idValue);
            }
            return;
        } else {
            if (!(idValue instanceof NodeBranchDataAdapter)) throw new ParseException("Invalid parameter type");
            NodeBranchDataAdapter adapter = (NodeBranchDataAdapter)idValue;
            if (!adapter.equals(this.getEdit().getCurrentTargetAdapter())) throw new ParseException("Functions iterating over all lines of a column cannot be called with \"THIS\".");
            stack.push(this.calculate(adapter));
        }
    }
}

