/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit.calculatecolumn;

public class ErrorInfo {
    private String uniqueNodeName;
    private String message;
    private boolean inValueExpression = true;

    public ErrorInfo(String message, boolean inValueExpression) {
        this(null, message, inValueExpression);
    }

    public ErrorInfo(String uniqueNodeName, String message, boolean inValueExpression) {
        if (message == null) {
            throw new NullPointerException("The message must not be null.");
        }
        this.uniqueNodeName = uniqueNodeName;
        this.message = message;
        this.inValueExpression = inValueExpression;
    }

    public String getUniqueNodeName() {
        return this.uniqueNodeName;
    }

    public boolean isNodeSpecific() {
        return this.getUniqueNodeName() != null;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isInValueExpression() {
        return this.inValueExpression;
    }

    public String getExpressionPrefix() {
        if (this.isInValueExpression()) {
            return "Error in value expression: ";
        }
        return "Error in target column expression: ";
    }

    public String toString() {
        if (this.isNodeSpecific()) {
            return "Calculating a value for the node " + this.getUniqueNodeName() + " was skipped because of the following error in calulating the target columns ID: \"" + this.getExpressionPrefix() + this.getMessage() + "\".";
        }
        return String.valueOf(this.getExpressionPrefix()) + this.getMessage();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inValueExpression ? 1231 : 1237);
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.uniqueNodeName == null ? 0 : this.uniqueNodeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorInfo other = (ErrorInfo)obj;
        if (this.inValueExpression != other.inValueExpression) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.uniqueNodeName == null ? other.uniqueNodeName != null : !this.uniqueNodeName.equals(other.uniqueNodeName));
    }
}

