/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit.calculatecolumn;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.undo.edit.CalculateColumnEdit;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommandI;

public abstract class AbstractFunction
implements PostfixMathCommandI {
    private CalculateColumnEdit edit;
    private int curNumberOfParameters = 1;

    public AbstractFunction(CalculateColumnEdit edit) {
        this.edit = edit;
    }

    public abstract String getName();

    public CalculateColumnEdit getEdit() {
        return this.edit;
    }

    public static Double codeBoolean(boolean value) {
        if (value) {
            return new Double(1.0);
        }
        return new Double(0.0);
    }

    public static double checkDouble(Object value) throws ParseException {
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new ParseException("Invalid parameter type. (Expected a numeric value.)");
    }

    public static long checkLong(Object value) throws ParseException {
        double doubleValue = AbstractFunction.checkDouble(value);
        if (Math2.isInt(doubleValue)) {
            return (long)doubleValue;
        }
        throw new ParseException("Invalid parameter type. (Expected an integer value.)");
    }

    public static int checkInteger(Object value) throws ParseException {
        long longValue = AbstractFunction.checkLong(value);
        if (Math2.isBetween(longValue, Integer.MIN_VALUE, Integer.MAX_VALUE)) {
            return (int)longValue;
        }
        throw new ParseException("Integer value out of range (" + longValue + "). Values must be between " + Integer.MIN_VALUE + " and " + Integer.MAX_VALUE + ".");
    }

    public static String checkString(Object value) throws ParseException {
        if (value instanceof String) {
            return (String)value;
        }
        throw new ParseException("Invalid parameter type. (Expected a textual value.)");
    }

    public void setCurNumberOfParameters(int n) {
        this.curNumberOfParameters = n;
    }

    protected int getCurNumberOfParameters() {
        return this.curNumberOfParameters;
    }
}

