/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.TextElement;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class TextElementEdit
extends DocumentEdit {
    private TextElement[] elements;
    private List<TextElementData> oldData;
    private TextElementData newData;

    public TextElementEdit(Document document, TextElement[] elements, TextElementData newData) {
        super(document, DocumentChangeType.TOPOLOGICAL_BY_RENAMING);
        this.elements = elements;
        this.oldData = new ArrayList<TextElementData>(elements.length);
        TextElement[] textElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            TextElement element = textElementArray[n2];
            this.oldData.add(element.getData().clone());
            ++n2;
        }
        this.newData = newData;
    }

    @Override
    public String getPresentationName() {
        return "Change Text to \"" + this.newData + "\"";
    }

    @Override
    public void redo() throws CannotRedoException {
        TextElement[] textElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            TextElement element = textElementArray[n2];
            element.getData().assign(this.newData);
            ++n2;
        }
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].getData().assign(this.oldData.get(i));
            ++i;
        }
        super.undo();
    }
}

