/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.document.undo.CompareTextElementDataParameters;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import info.bioinfweb.treegraph.document.undo.WarningMessageEdit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class SortLeavesEdit
extends DocumentEdit
implements WarningMessageEdit {
    public static final int MAX_WARNING_ELEMENTS = 8;
    public static final String ATTRIBUTE_ID = String.valueOf(SortLeavesEdit.class.getCanonicalName()) + "_averageIndex";
    private static final NodeComparator NODE_COMPARATOR = new NodeComparator();
    private Node root;
    private List<Node> newOrder;
    private List<Node> oldOrder;
    private NodeBranchDataAdapter leafAdapter;
    private CompareTextElementDataParameters parameters;
    private List<TextElementData> unlinkedOrderValues = new ArrayList<TextElementData>();
    private List<TextElementData> unlinkedTreeValues = new ArrayList<TextElementData>();

    public SortLeavesEdit(Document document, Node root, List<TextElementData> newOrder, NodeBranchDataAdapter leafAdapter, CompareTextElementDataParameters parameters) {
        super(document, DocumentChangeType.NODE_ORDER);
        this.root = root;
        this.leafAdapter = leafAdapter;
        this.parameters = parameters;
        this.saveNewOrder(newOrder);
        this.oldOrder = TreeSerializer.getElementsInSubtreeAsList(root, NodeType.LEAVES, Node.class);
    }

    private void saveNewOrder(List<TextElementData> order) {
        this.newOrder = new ArrayList<Node>();
        for (TextElementData data : order) {
            Node node = this.getDocument().getTree().getFirstNodeByData(this.leafAdapter, data, true, this.parameters);
            if (node != null) {
                this.newOrder.add(node);
                continue;
            }
            this.unlinkedOrderValues.add(data);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private SortInfo sortLeafs(Node root, List<Node> order) {
        SortInfo result = new SortInfo();
        if (root.isLeaf()) {
            if (order.contains(root)) {
                result.nodeCount = 1;
                result.indexSum = order.indexOf(root);
                return result;
            }
            this.unlinkedTreeValues.add(root.getData());
            return null;
        }
        for (Node child : root.getChildren()) {
            SortInfo childInfo = this.sortLeafs(child, order);
            if (childInfo != null) {
                child.getAttributeMap().put(ATTRIBUTE_ID, childInfo.averageIndex());
                result.add(childInfo);
                continue;
            }
            child.getAttributeMap().put(ATTRIBUTE_ID, Double.MAX_VALUE);
        }
        Collections.sort(root.getChildren(), NODE_COMPARATOR);
        return result;
    }

    @Override
    public void redo() throws CannotRedoException {
        this.unlinkedTreeValues.clear();
        this.sortLeafs(this.root, this.newOrder);
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.unlinkedTreeValues.clear();
        this.sortLeafs(this.root, this.oldOrder);
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Sort leaves";
    }

    private void addListToWarningText(List<TextElementData> list, StringBuffer buffer) {
        int length = Math.min(8, list.size());
        int i = 0;
        while (i < list.size()) {
            buffer.append("- \"" + list.get(i).toString() + "\"\n");
            ++i;
        }
        if (list.size() > 8) {
            buffer.append(String.valueOf(list.size() - length) + " more...");
        }
    }

    @Override
    public String getWarningText() {
        if (this.hasWarnings()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("The leaf elements of the tree and the elements in the order list were not identical:\n\n");
            if (!this.unlinkedOrderValues.isEmpty()) {
                buffer.append("The following elements from the order list (loaded list or other tree document) have not been ");
                buffer.append("found in the tree:\n\n");
                this.addListToWarningText(this.unlinkedOrderValues, buffer);
                buffer.append("\n\n");
            }
            if (!this.unlinkedTreeValues.isEmpty()) {
                buffer.append("The following elements from the tree have not been found in the order list:\n\n");
                this.addListToWarningText(this.unlinkedTreeValues, buffer);
                buffer.append("\nThese elements have been positioned as the last elements in their subtree.");
            }
            return buffer.toString();
        }
        return null;
    }

    @Override
    public boolean hasWarnings() {
        return !this.unlinkedOrderValues.isEmpty() || !this.unlinkedTreeValues.isEmpty();
    }

    public static List<TextElementData> orderFromTextFile(File file, CompareTextElementDataParameters parameters) throws IOException {
        ArrayList<TextElementData> result = new ArrayList<TextElementData>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            while (line != null) {
                result.add(parameters.createEditedValue(line));
                line = reader.readLine();
            }
        }
        return result;
    }

    public static List<TextElementData> orderFromDocument(Document document, NodeBranchDataAdapter adapter, CompareTextElementDataParameters parameters) {
        List<Node> leaves = TreeSerializer.getElementsInSubtreeAsList(document.getTree().getPaintStart(), NodeType.LEAVES, Node.class);
        ArrayList<TextElementData> result = new ArrayList<TextElementData>(leaves.size());
        for (Node node : leaves) {
            result.add(parameters.createEditedValue(adapter.toTextElementData(node).toString()));
        }
        return result;
    }

    private static class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node n1, Node n2) {
            return (int)Math.signum((Double)n1.getAttributeMap().get(ATTRIBUTE_ID) - (Double)n2.getAttributeMap().get(ATTRIBUTE_ID));
        }
    }

    private static class SortInfo {
        public int indexSum = 0;
        public int nodeCount = 0;

        private SortInfo() {
        }

        public void add(SortInfo other) {
            this.indexSum += other.indexSum;
            this.nodeCount += other.nodeCount;
        }

        public double averageIndex() {
            return (double)this.indexSum / (double)this.nodeCount;
        }
    }
}

