/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class SeparateBranchEdit
extends DocumentEdit {
    private Branch branchToSplit;
    private Node insertedNode = Node.newInstanceWithBranch();
    private int index;

    public SeparateBranchEdit(Document document, Branch branch) {
        super(document, DocumentChangeType.TOPOLOGICAL_LEAF_INVARIANT);
        this.branchToSplit = branch;
        this.insertedNode.getFormats().assign(branch.getTargetNode().getFormats());
        this.insertedNode.getAfferentBranch().getFormats().assign(branch.getFormats());
        if (this.branchToSplit.hasLength()) {
            this.insertedNode.getAfferentBranch().setLength(0.5 * this.branchToSplit.getLength());
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.branchToSplit.getTargetNode().hasParent()) {
            Node parent = this.branchToSplit.getTargetNode().getParent();
            this.index = parent.getChildren().indexOf(this.branchToSplit.getTargetNode());
            parent.getChildren().remove(this.index);
            this.branchToSplit.getTargetNode().setParent(this.insertedNode);
            this.insertedNode.getChildren().add(this.branchToSplit.getTargetNode());
            this.insertedNode.setParent(parent);
            parent.getChildren().add(this.index, this.insertedNode);
        } else {
            this.getDocument().getTree().setPaintStart(this.insertedNode);
            this.branchToSplit.getTargetNode().setParent(this.insertedNode);
            this.insertedNode.getChildren().add(this.branchToSplit.getTargetNode());
        }
        if (this.branchToSplit.hasLength()) {
            this.branchToSplit.setLength(0.5 * this.branchToSplit.getLength());
        }
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.insertedNode.getChildren().remove(this.branchToSplit.getTargetNode());
        if (this.insertedNode.hasParent()) {
            Node parent = this.insertedNode.getParent();
            parent.getChildren().remove(this.insertedNode);
            this.branchToSplit.getTargetNode().setParent(parent);
            parent.getChildren().add(this.index, this.branchToSplit.getTargetNode());
        } else {
            this.branchToSplit.getTargetNode().setParent(null);
            this.getDocument().getTree().setPaintStart(this.branchToSplit.getTargetNode());
        }
        if (this.branchToSplit.hasLength()) {
            this.branchToSplit.setLength(2.0 * this.branchToSplit.getLength());
        }
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Seperate branch";
    }
}

