/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.ComplexDocumentEdit;
import info.bioinfweb.treegraph.document.undo.WarningMessageEdit;
import java.util.List;

public class RerootEdit
extends ComplexDocumentEdit
implements WarningMessageEdit {
    public static final int DIALOG_HELP_TOPIC = 24;
    private Branch rootingPoint = null;
    private String warningText = null;

    public RerootEdit(Document document, Branch rootingPoint) {
        super(document, DocumentChangeType.ROOT_POSITION);
        this.rootingPoint = this.findEquivalent(rootingPoint);
    }

    protected RerootEdit(Document document) {
        super(document, DocumentChangeType.ROOT_POSITION);
    }

    public Branch getRootingPoint() {
        return this.rootingPoint;
    }

    protected void setRootingPoint(Branch rootingPoint) {
        this.rootingPoint = rootingPoint;
    }

    private static void copyLabels(Labels source, Labels target) {
        Label[] labels = source.toLabelArray();
        int i = 0;
        while (i < labels.length) {
            target.add(labels[i].clone());
            ++i;
        }
    }

    private static void copyBranchData(Branch source, Branch target) {
        target.getHiddenDataMap().putAll(source.getHiddenDataMap());
        RerootEdit.copyLabels(source.getLabels(), target.getLabels());
        if (source.hasLength()) {
            if (target.hasLength()) {
                target.setLength(source.getLength() + target.getLength());
            } else {
                target.setLength(source.getLength());
            }
        }
    }

    private static String createWarningMessage(Node root, boolean rootNodeDeleted) {
        Branch rootBranch;
        String msg = "";
        if (rootNodeDeleted) {
            if (!root.getData().isEmpty() && !"".equals(root.getData().getText())) {
                msg = String.valueOf(msg) + "- The former root node (which has been deleted) contained the node name \"" + root.getData().toString() + "\".\n";
            }
            if (!root.getHiddenDataMap().isEmpty()) {
                msg = String.valueOf(msg) + "- The former root node (which has been deleted) contained hidden node data.\n";
            }
        }
        if ((rootBranch = root.getAfferentBranch()).hasLength()) {
            msg = String.valueOf(msg) + "- The former root branch (which has been deleted) had a specified length of " + rootBranch.getLength() + ".\n";
        }
        if (!rootBranch.getLabels().isEmpty()) {
            msg = String.valueOf(msg) + "- The former root branch (which has been deleted) was carrying one or more labels.\n";
        }
        if (!rootBranch.getHiddenDataMap().isEmpty()) {
            msg = String.valueOf(msg) + "- The former root branch (which has been deleted) contained hidden branch data.\n";
        }
        if (rootNodeDeleted) {
            Branch b1 = root.getChildren().get(0).getAfferentBranch();
            Branch b2 = root.getChildren().get(1).getAfferentBranch();
            if (b1.getLabels().containsSameID(b2.getLabels())) {
                msg = String.valueOf(msg) + "- The two child branches of the root contained one or more labels with the same ID(s). One element of each ID has been deleted.\n";
            }
            if (b1.getHiddenDataMap().containsSameID(b2.getHiddenDataMap())) {
                msg = String.valueOf(msg) + "- The two child branches of the root contained hidden branch data with the same ID. One element of each ID has been deleted.\n";
            }
        }
        if (!"".equals(msg)) {
            return "Rerooting produced warnings:\n\n" + msg + "\nYou can use the undo-function to restore lost data.";
        }
        return null;
    }

    @Override
    public String getWarningText() {
        return this.warningText;
    }

    @Override
    public boolean hasWarnings() {
        return this.warningText != null;
    }

    private static void separateRootBranchLength(Tree tree) {
        List<Node> nodes = tree.getPaintStart().getChildren();
        if (nodes.size() != 2) {
            throw new InternalError("Unexpected tree topology after rerooting.");
        }
        double halfLength = Double.NaN;
        if (nodes.get(0).getAfferentBranch().hasLength()) {
            halfLength = 0.5 * nodes.get(0).getAfferentBranch().getLength();
        } else if (nodes.get(1).getAfferentBranch().hasLength()) {
            halfLength = 0.5 * nodes.get(1).getAfferentBranch().getLength();
        }
        if (!Double.isNaN(halfLength)) {
            nodes.get(0).getAfferentBranch().setLength(halfLength);
            nodes.get(1).getAfferentBranch().setLength(halfLength);
            tree.getPaintStart().getAfferentBranch().setLength(0.0);
        }
    }

    private static Node createNewRoot(Node rootingPoint) {
        Node result = Node.newInstanceWithBranch();
        result.getFormats().assign(rootingPoint.getFormats());
        result.getFormats().assignLineFormats(rootingPoint.getAfferentBranch().getFormats());
        result.getAfferentBranch().getFormats().assign(rootingPoint.getAfferentBranch().getFormats());
        return result;
    }

    private static Branch createNewBranchUnderRoot(Node targetNode) {
        Branch result = new Branch(targetNode);
        result.getFormats().assign(targetNode.getAfferentBranch().getFormats());
        return result;
    }

    public static String reroot(Tree tree, Branch position) {
        String result = null;
        Node parent = position.getTargetNode().getParent();
        if (parent != null) {
            List<Node> children = tree.getPaintStart().getChildren();
            boolean collapseFormerRoot = children.size() == 2;
            result = RerootEdit.createWarningMessage(tree.getPaintStart(), collapseFormerRoot);
            if (collapseFormerRoot) {
                if (children.get(0).containedInSubtree(position)) {
                    RerootEdit.copyBranchData(children.get(0).getAfferentBranch(), children.get(1).getAfferentBranch());
                } else {
                    RerootEdit.copyBranchData(children.get(1).getAfferentBranch(), children.get(0).getAfferentBranch());
                }
            }
            Node current = RerootEdit.createNewRoot(position.getTargetNode());
            tree.setPaintStart(current);
            parent.getChildren().remove(position.getTargetNode());
            current.getChildren().add(position.getTargetNode());
            position.getTargetNode().setParent(current);
            position = parent.getAfferentBranch();
            parent.setAfferentBranch(RerootEdit.createNewBranchUnderRoot(parent));
            current.getChildren().add(0, parent);
            Node last = current;
            current = parent;
            parent = parent.getParent();
            current.setParent(last);
            while (parent != null) {
                current.getChildren().add(0, parent);
                last = current;
                current = parent;
                parent = parent.getParent();
                Branch b2 = current.getAfferentBranch();
                current.setAfferentBranch(position);
                position = b2;
                current.getChildren().remove(last);
                current.setParent(last);
            }
            RerootEdit.separateRootBranchLength(tree);
            if (collapseFormerRoot) {
                parent = current.getParent();
                parent.getChildren().remove(current);
                parent.getChildren().add(current.getChildren().get(0));
                current.getChildren().get(0).setParent(parent);
            }
        }
        return result;
    }

    @Override
    protected void performRedo() {
        this.warningText = RerootEdit.reroot(this.getDocument().getTree(), this.rootingPoint);
    }

    @Override
    public String getPresentationName() {
        return "Reroot tree";
    }
}

