/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.nodebranchdata.UniqueNameAdapter;
import info.bioinfweb.treegraph.document.topologicalcalculation.LeafSet;
import info.bioinfweb.treegraph.document.undo.AbstractTopologicalCalculationEdit;
import info.bioinfweb.treegraph.document.undo.WarningMessageEdit;
import info.bioinfweb.treegraph.document.undo.edit.RerootEdit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RerootByLeafSetEdit
extends AbstractTopologicalCalculationEdit
implements WarningMessageEdit {
    private Branch rootingPoint;
    private List<Node> leaves;
    private LeafSet selectedLeaves;
    private HashSet<Node> nodesOnPath = new HashSet();
    private String warningText = null;
    private Collection<Branch> alternativeRootingPoints = new ArrayList<Branch>(8);

    public RerootByLeafSetEdit(Document document, List<Node> leaves) {
        super(document, DocumentChangeType.ROOT_POSITION, UniqueNameAdapter.getSharedInstance(), false);
        this.leaves = leaves;
        this.rootingPoint = this.calculateRootingPoint();
        this.nodesOnPath = null;
    }

    public RerootByLeafSetEdit(Document document, Node[] leaves) {
        super(document, DocumentChangeType.ROOT_POSITION, UniqueNameAdapter.getSharedInstance(), false);
        this.leaves = Arrays.asList(leaves);
        this.rootingPoint = this.calculateRootingPoint();
        this.nodesOnPath = null;
    }

    private void createSelectedLeafSet() {
        this.selectedLeaves = new LeafSet(this.getTopologicalCalculator().getLeafCount());
        Iterator<Node> iterator = this.leaves.iterator();
        while (iterator.hasNext()) {
            this.selectedLeaves.setChild(this.getTopologicalCalculator().getLeafIndex(UniqueNameAdapter.getSharedInstance().toTextElementData(iterator.next()).toString()), true);
        }
    }

    private void markPath(Node node) {
        node = node.getParent();
        while (node != null && !this.nodesOnPath.contains(node) && !this.getTopologicalCalculator().getLeafSet(node).containsAll(this.selectedLeaves)) {
            this.nodesOnPath.add(node);
            node = node.getParent();
        }
        if (node != null && !this.nodesOnPath.contains(node)) {
            this.nodesOnPath.add(node);
        }
    }

    private BranchingSubtreesResult largestBranchingSubtrees(Node root) {
        BranchingSubtreesResult result = new BranchingSubtreesResult();
        if (root.hasParent() && !this.nodesOnPath.contains(root.getParent())) {
            result.first = root.getAfferentBranch();
            result.leafCount = this.getTopologicalCalculator().getLeafSet(root).complement().childCount();
        }
        for (Node child : root.getChildren()) {
            if (this.nodesOnPath.contains(child)) continue;
            int childLeafCount = this.getTopologicalCalculator().getLeafSet(child).childCount();
            if (childLeafCount > result.leafCount) {
                result.alternatives.clear();
                result.first = child.getAfferentBranch();
                result.leafCount = childLeafCount;
                continue;
            }
            if (childLeafCount != result.leafCount) continue;
            result.alternatives.add(child.getAfferentBranch());
        }
        return result;
    }

    private void findEquivalentAlternativeRootingPoints() {
        ArrayList<Branch> copy = new ArrayList<Branch>(this.alternativeRootingPoints);
        this.alternativeRootingPoints.clear();
        Iterator<Branch> iterator = copy.iterator();
        while (iterator.hasNext()) {
            this.alternativeRootingPoints.add(this.findEquivalent(iterator.next()));
        }
    }

    private Branch calculateRootingPoint() {
        Branch result = null;
        if (this.leaves.size() > 1) {
            this.getTopologicalCalculator().addLeafSets(this.getDocument().getTree().getPaintStart(), UniqueNameAdapter.getSharedInstance());
            this.createSelectedLeafSet();
            for (Node leaf : this.leaves) {
                if (leaf.isLeaf()) {
                    this.markPath(leaf);
                    continue;
                }
                throw new IllegalArgumentException("The specified node with the unique name " + leaf.getUniqueName() + " is not a leaf.");
            }
            this.alternativeRootingPoints.clear();
            int maxLeafCount = 0;
            Iterator<Node> iterator = this.nodesOnPath.iterator();
            while (iterator.hasNext()) {
                BranchingSubtreesResult subtrees = this.largestBranchingSubtrees(iterator.next());
                if (subtrees.leafCount > maxLeafCount) {
                    this.alternativeRootingPoints.clear();
                    result = subtrees.first;
                    this.alternativeRootingPoints.addAll(subtrees.alternatives);
                    maxLeafCount = subtrees.leafCount;
                    continue;
                }
                if (subtrees.leafCount != maxLeafCount) continue;
                this.alternativeRootingPoints.add(subtrees.first);
                this.alternativeRootingPoints.addAll(subtrees.alternatives);
            }
            this.findEquivalentAlternativeRootingPoints();
        } else if (this.leaves.size() == 1) {
            this.alternativeRootingPoints.clear();
            result = this.leaves.get(0).getAfferentBranch();
        } else {
            throw new IllegalArgumentException("At least one leaf node needs to be specified to define the new root.");
        }
        return this.findEquivalent(result);
    }

    public Collection<Branch> getAlternativeRootingPoints() {
        return Collections.unmodifiableCollection(this.alternativeRootingPoints);
    }

    @Override
    public String getWarningText() {
        return this.warningText;
    }

    @Override
    public boolean hasWarnings() {
        return this.warningText != null;
    }

    @Override
    public String getPresentationName() {
        return "Reroot tree by leaf (taxon) set";
    }

    @Override
    protected void performRedo() {
        this.warningText = RerootEdit.reroot(this.getDocument().getTree(), this.rootingPoint);
    }

    private static class BranchingSubtreesResult {
        public Branch first;
        public List<Branch> alternatives = new ArrayList<Branch>(4);
        public int leafCount = -1;

        private BranchingSubtreesResult() {
        }
    }
}

