/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.ComplexDocumentEdit;
import java.util.regex.Pattern;

public class ReplaceInNodeDataEdit
extends ComplexDocumentEdit {
    private NodeBranchDataAdapter adapter = null;
    private InsertPosition position = null;
    private Pattern searchPattern = null;
    private String newText = null;

    public ReplaceInNodeDataEdit(Document document, NodeBranchDataAdapter adapter, InsertPosition position, String oldText, String newText, boolean caseSensitive, boolean wordsOnly) {
        super(document, DocumentChangeType.TOPOLOGICAL_BY_RENAMING);
        this.adapter = adapter;
        this.position = position;
        if (position.equals((Object)InsertPosition.REPLACE)) {
            this.searchPattern = ReplaceInNodeDataEdit.generatePattern(oldText, caseSensitive, wordsOnly);
        }
        this.newText = newText;
    }

    public static Pattern generatePattern(String text, boolean caseSensitive, boolean wordsOnly) {
        String code = Pattern.quote(text);
        if (wordsOnly) {
            code = "(^|\\b)" + code + "($|\\b)";
        }
        int flags = 32;
        if (!caseSensitive) {
            flags += 2;
        }
        return Pattern.compile(code, flags);
    }

    private void replace(Node root) {
        String text = this.adapter.getText(root);
        if (text != null && !this.adapter.decimalOnly()) {
            switch (this.position) {
                case BEFORE: {
                    text = String.valueOf(this.newText) + text;
                    break;
                }
                case AFTER: {
                    text = String.valueOf(text) + this.newText;
                    break;
                }
                case REPLACE: {
                    text = this.searchPattern.matcher(text).replaceAll(this.newText);
                }
            }
            this.adapter.setText(root, text);
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            this.replace(root.getChildren().get(i));
            ++i;
        }
    }

    @Override
    protected void performRedo() {
        if (!this.getDocument().getTree().isEmpty()) {
            this.replace(this.getDocument().getTree().getPaintStart());
        }
    }

    @Override
    public String getPresentationName() {
        return "Replace text in node data";
    }

    public static enum InsertPosition {
        BEFORE,
        AFTER,
        REPLACE;

    }
}

