/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class RenameDataIDEdit
extends DocumentEdit {
    private String[] newIDs;
    private String[] oldIDs;

    public RenameDataIDEdit(Document document, String[] newIDs, String[] oldIDs) {
        super(document, DocumentChangeType.TOPOLOGICAL_BY_RENAMING);
        this.newIDs = newIDs;
        this.oldIDs = oldIDs;
    }

    @Override
    public void redo() throws CannotRedoException {
        int i = 0;
        while (i < this.oldIDs.length) {
            IDManager.renameID(this.oldIDs[i], this.newIDs[i], this.getDocument());
            ++i;
        }
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        int i = 0;
        while (i < this.oldIDs.length) {
            IDManager.renameID(this.newIDs[i], this.oldIDs[i], this.getDocument());
            ++i;
        }
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Rename data ID(s)";
    }
}

