/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.undo.WarningMessageEdit;
import info.bioinfweb.treegraph.document.undo.edit.CollapseNodeEdit;
import info.bioinfweb.treegraph.document.undo.edit.InsertRemoveSubtreeEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class RemoveSubtreeEdit
extends InsertRemoveSubtreeEdit
implements WarningMessageEdit {
    private CollapseNodeEdit collapseNodeEdit = null;
    private boolean collapseDone = false;

    public RemoveSubtreeEdit(Document document, Node parent, Node root, int index) {
        super(document, parent, root, index);
        if (parent != null && parent.getChildren().size() <= 2) {
            this.collapseNodeEdit = new CollapseNodeEdit(document, parent);
        }
    }

    @Override
    public boolean getLegendsReanchored() {
        boolean result = super.getLegendsReanchored();
        if (this.collapseNodeEdit != null) {
            result |= this.collapseNodeEdit.getLegendsReanchored();
        }
        return result;
    }

    @Override
    public boolean getLegendsRemoved() {
        boolean result = super.getLegendsRemoved();
        if (this.collapseNodeEdit != null) {
            result |= this.collapseNodeEdit.getLegendsRemoved();
        }
        return result;
    }

    @Override
    public void redo() throws CannotRedoException {
        this.saveLegends();
        this.editSubtreeLegends(this.root);
        this.remove();
        if (this.parent != null && this.parent.getChildren().size() == 1) {
            this.collapseNodeEdit.redo();
            this.collapseDone = true;
        }
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.collapseDone) {
            this.collapseNodeEdit.undo();
        }
        this.insert();
        this.restoreLegends();
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Remove subtree";
    }
}

