/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.PieChartLabel;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class PieChartLabelIDsEdit
extends DocumentEdit {
    private PieChartLabel[] labels;
    private List<PieChartLabel.SectionData> newIDs;
    private List<List<PieChartLabel.SectionData>> oldIDs;

    public PieChartLabelIDsEdit(Document document, PieChartLabel[] labels, List<PieChartLabel.SectionData> newIDs) {
        super(document, DocumentChangeType.NEUTRAL);
        this.labels = labels;
        this.newIDs = newIDs;
        this.oldIDs = new ArrayList<List<PieChartLabel.SectionData>>(labels.length);
        int i = 0;
        while (i < labels.length) {
            this.oldIDs.add(new ArrayList<PieChartLabel.SectionData>(labels[i].getSectionDataList()));
            ++i;
        }
    }

    private void setIDs(List<PieChartLabel.SectionData> ids, int labelIndex) {
        this.labels[labelIndex].getSectionDataList().clear();
        this.labels[labelIndex].getSectionDataList().addAll(ids);
    }

    @Override
    public void redo() throws CannotRedoException {
        int i = 0;
        while (i < this.labels.length) {
            this.setIDs(this.newIDs, i);
            ++i;
        }
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        int i = 0;
        while (i < this.labels.length) {
            this.setIDs(this.oldIDs.get(i), i);
            ++i;
        }
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Change pie chart label value ID(s)";
    }
}

