/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import info.bioinfweb.treegraph.document.undo.edit.LegendPaster;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class PasteSubtreeEdit
extends DocumentEdit {
    private Node parent = null;
    private Node root = null;
    private LegendPaster legendPaster;

    public PasteSubtreeEdit(Document document, Node parent, Node root, Legend[] legends) {
        super(document, DocumentChangeType.TOPOLOGICAL_BY_OBJECT_CHANGE);
        this.parent = parent;
        this.root = root;
        this.legendPaster = new LegendPaster(document, legends);
    }

    @Override
    public void redo() throws CannotRedoException {
        this.legendPaster.changeUniqueNames(this.root);
        this.root.setParent(this.parent);
        this.parent.getChildren().add(this.root);
        this.legendPaster.pasteLegends();
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.parent.getChildren().remove(this.root);
        this.root.setParent(null);
        this.legendPaster.removeLegends();
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Paste subtree";
    }
}

