/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class MoveSubtreeEdit
extends DocumentEdit {
    protected Node root;
    protected boolean down;

    public MoveSubtreeEdit(Document document, Node root, boolean down) {
        super(document, DocumentChangeType.NODE_ORDER);
        this.root = root;
        this.down = down;
    }

    private void move(boolean down) {
        Node parent = this.root.getParent();
        int newPos = parent.getChildren().indexOf(this.root);
        newPos = down ? ++newPos : --newPos;
        parent.getChildren().remove(this.root);
        parent.getChildren().add(newPos, this.root);
    }

    @Override
    public void redo() throws CannotRedoException {
        this.move(this.down);
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.move(!this.down);
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Move Subtree";
    }
}

