/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.format.LegendFormats;
import java.util.HashMap;
import java.util.Map;

public class LegendPaster {
    private Document document;
    private Legend[] legends = null;
    private boolean uniqueNamesChanged = false;
    private Map<String, String> uniqueNameMap = new HashMap<String, String>();

    public LegendPaster(Document document, Legend[] legends) {
        this.document = document;
        this.legends = legends;
    }

    private String newUniqueName() {
        String result;
        while (this.uniqueNameMap.containsValue(result = this.document.getTree().newUniqueName())) {
        }
        return result;
    }

    private void changeUniqueNamesSubtree(Node root) {
        String previousName = root.getUniqueName();
        root.setUniqueName(this.newUniqueName());
        this.uniqueNameMap.put(previousName, root.getUniqueName());
        int i = 0;
        while (i < root.getChildren().size()) {
            this.changeUniqueNamesSubtree(root.getChildren().get(i));
            ++i;
        }
    }

    private void changeUniqueNamesLegends() {
        int i = 0;
        while (i < this.legends.length) {
            LegendFormats f = this.legends[i].getFormats();
            int j = 0;
            while (j <= 1) {
                if (f.getAnchorName(j) != null) {
                    f.setAnchorName(j, this.uniqueNameMap.get(f.getAnchorName(j)));
                }
                ++j;
            }
            ++i;
        }
    }

    public void changeUniqueNames(Node root) {
        if (!this.uniqueNamesChanged) {
            this.changeUniqueNamesSubtree(root);
            this.changeUniqueNamesLegends();
            this.uniqueNamesChanged = true;
        }
    }

    public void pasteLegends() {
        int i = 0;
        while (i < this.legends.length) {
            this.document.getTree().getLegends().insert(this.legends[i]);
            ++i;
        }
    }

    public void removeLegends() {
        int i = 0;
        while (i < this.legends.length) {
            this.document.getTree().getLegends().remove(this.legends[i]);
            ++i;
        }
    }
}

