/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeLadderizeComparable;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.ComplexDocumentEdit;
import java.util.Arrays;

public class LadderizeEdit
extends ComplexDocumentEdit {
    private Node root = null;
    private boolean down = true;

    public LadderizeEdit(Document document, Node root, boolean down) {
        super(document, DocumentChangeType.NODE_ORDER);
        this.root = this.findEquivilant(root);
        this.down = down;
    }

    private void ladderize(Node root, boolean down) {
        if (!root.isLeaf()) {
            Object[] subtrees = NodeLadderizeComparable.incloseSubnodes(root, down);
            root.getChildren().clear();
            Arrays.sort(subtrees);
            NodeLadderizeComparable.addToNode((NodeLadderizeComparable[])subtrees, root);
            int i = 0;
            while (i < root.getChildren().size()) {
                this.ladderize(root.getChildren().get(i), down);
                ++i;
            }
        }
    }

    @Override
    protected void performRedo() {
        NodeLadderizeComparable.countNodes(this.root);
        this.ladderize(this.root, this.down);
    }

    @Override
    public String getPresentationName() {
        return "Ladderize subtree";
    }
}

