/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class InsertSiblingEdit
extends DocumentEdit {
    private Node firstSibling;
    private Node newParent = Node.newInstanceWithBranch();

    public InsertSiblingEdit(Document document, Node firstSibling, Node newSibling) {
        super(document, DocumentChangeType.TOPOLOGICAL_BY_OBJECT_CHANGE);
        this.firstSibling = firstSibling;
        this.newParent.getFormats().assign(firstSibling.getFormats());
        this.newParent.getAfferentBranch().getFormats().assign(firstSibling.getAfferentBranch().getFormats());
        this.newParent.getChildren().add(firstSibling);
        this.newParent.getChildren().add(newSibling);
        this.newParent.setParent(firstSibling.getParent());
        newSibling.setParent(this.newParent);
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.firstSibling.hasParent()) {
            Node parent = this.firstSibling.getParent();
            int index = parent.getChildren().indexOf(this.firstSibling);
            parent.getChildren().remove(index);
            parent.getChildren().add(index, this.newParent);
        } else {
            this.getDocument().getTree().setPaintStart(this.newParent);
        }
        this.firstSibling.setParent(this.newParent);
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        Node parent = this.newParent.getParent();
        if (this.newParent.hasParent()) {
            int index = parent.getChildren().indexOf(this.newParent);
            parent.getChildren().remove(index);
            parent.getChildren().add(index, this.firstSibling);
        } else {
            this.getDocument().getTree().setPaintStart(this.firstSibling);
        }
        this.firstSibling.setParent(parent);
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Insert Sibling";
    }
}

