/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.DuplicateIDException;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.format.LabelFormats;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;

public abstract class InsertRemoveLabelEdit
extends DocumentEdit {
    protected Label label;
    protected Labels owner;

    public InsertRemoveLabelEdit(Document document, Label label, Labels owner) {
        super(document, DocumentChangeType.TOPOLOGICAL_BY_RENAMING);
        this.label = label;
        this.owner = owner;
    }

    protected void insert() {
        if (IDManager.idExistsOnNode(this.owner.getHoldingBranch().getTargetNode(), this.label.getID())) {
            throw new DuplicateIDException(this.label.getID(), this.owner.getHoldingBranch().getTargetNode());
        }
        LabelFormats f = this.label.getFormats();
        f.setLinePosition(this.owner.getLastLinePos(f.isAbove(), f.getLineNumber()));
        this.label.setLabels(this.owner);
        this.owner.add(this.label);
    }

    protected void remove() {
        this.owner.remove(this.label);
        this.label.setLabels(null);
    }
}

