/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.SaveLegendsEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class DeleteSubelementsEdit
extends SaveLegendsEdit {
    private Node root;
    private Node[] subnodes;

    public DeleteSubelementsEdit(Document document, Node root) {
        super(document, DocumentChangeType.TOPOLOGICAL_BY_OBJECT_CHANGE);
        this.root = root;
        this.subnodes = new Node[root.getChildren().size()];
        int i = 0;
        while (i < root.getChildren().size()) {
            this.subnodes[i] = root.getChildren().get(i);
            ++i;
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.saveLegends();
        this.editSubtreeLegends(this.root);
        this.root.getChildren().clear();
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        int i = 0;
        while (i < this.subnodes.length) {
            this.root.getChildren().add(this.subnodes[i]);
            ++i;
        }
        this.restoreLegends();
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Delete subelements";
    }
}

