/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.nodebranchdata.NodeBranchDataEdit;
import javax.swing.undo.CannotRedoException;

public class DeleteOutsideIntervalEdit
extends NodeBranchDataEdit {
    private double lowerBorder;
    private double upperBorder;

    public DeleteOutsideIntervalEdit(Document document, NodeBranchDataAdapter adapter, double lowerBorder, double upperBorder) {
        super(document, adapter);
        this.lowerBorder = lowerBorder;
        this.upperBorder = upperBorder;
    }

    private void deleteOutsideIntervalSubtree(Node root) {
        double value;
        if (this.getAdapter().isDecimal(root) && ((value = this.getAdapter().getDecimal(root)) < this.lowerBorder || value > this.upperBorder)) {
            this.getAdapter().delete(root);
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            this.deleteOutsideIntervalSubtree(root.getChildren().get(i));
            ++i;
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.deleteOutsideIntervalSubtree(this.getDocument().getTree().getPaintStart());
        super.redo();
    }

    @Override
    public String getPresentationName() {
        return "Delete values outide [" + this.lowerBorder + ", " + this.upperBorder + "] in \"" + this.getAdapter().toString() + "\"";
    }
}

