/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.AbstractPaintableElement;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.ComposedDocumentEdit;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import info.bioinfweb.treegraph.document.undo.WarningMessageEdit;
import info.bioinfweb.treegraph.document.undo.edit.RemoveLabelEdit;
import info.bioinfweb.treegraph.document.undo.edit.RemoveLegendEdit;
import info.bioinfweb.treegraph.document.undo.edit.RemoveSubtreeEdit;
import java.util.HashSet;
import java.util.Iterator;

public class DeleteEdit
extends ComposedDocumentEdit
implements WarningMessageEdit {
    private HashSet<AbstractPaintableElement> elements = new HashSet();

    public DeleteEdit(Document document, AbstractPaintableElement[] elements) {
        super(document, DocumentChangeType.TOPOLOGICAL_BY_OBJECT_CHANGE);
        int i = 0;
        while (i < elements.length) {
            this.elements.add(elements[i]);
            ++i;
        }
        this.deleteSubtreeElements();
        this.createSubedits();
    }

    @Override
    public String getWarningText() {
        for (DocumentEdit edit : this.getEdits()) {
            RemoveSubtreeEdit removeSubtreeEdit;
            if (!(edit instanceof RemoveSubtreeEdit) || !(removeSubtreeEdit = (RemoveSubtreeEdit)edit).hasWarnings()) continue;
            return removeSubtreeEdit.getWarningText();
        }
        return null;
    }

    @Override
    public boolean hasWarnings() {
        return this.getWarningText() != null;
    }

    private boolean containsParent(Node node) {
        boolean result = false;
        node = node.getParent();
        while (!result && node != null) {
            result = this.elements.contains(node);
            node = node.getParent();
        }
        return result;
    }

    private void deleteSubtreeElements() {
        Iterator<AbstractPaintableElement> iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            AbstractPaintableElement element = iterator.next();
            Node node = Tree.getLinkedNode(element);
            if (node == null || (node == element || !this.elements.contains(node)) && !this.containsParent(node)) continue;
            iterator.remove();
        }
    }

    private void createSubedits() {
        Iterator<AbstractPaintableElement> iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            DocumentEdit edit = null;
            AbstractPaintableElement element = iterator.next();
            if (element instanceof Branch) {
                element = ((Branch)element).getTargetNode();
            }
            if (element instanceof Node) {
                int index = 0;
                if (((Node)element).hasParent()) {
                    index = ((Node)element).getParent().getChildren().indexOf((Node)element);
                }
                edit = new RemoveSubtreeEdit(this.getDocument(), ((Node)element).getParent(), (Node)element, index);
            } else if (element instanceof Label) {
                edit = new RemoveLabelEdit(this.getDocument(), (Label)element, ((Label)element).getLabels());
            } else if (element instanceof Legend) {
                edit = new RemoveLegendEdit(this.getDocument(), (Legend)element);
            }
            if (edit == null) continue;
            edit.setIsSubedit(true);
            this.getEdits().add(edit);
        }
    }

    @Override
    public String getPresentationName() {
        return "Delete element(s)";
    }
}

