/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.nodebranchdata.NodeBranchDataEdit;
import javax.swing.undo.CannotRedoException;

public class CopyColumnEdit
extends NodeBranchDataEdit {
    private NodeBranchDataAdapter source;
    private boolean includeLeaves;

    public CopyColumnEdit(Document document, NodeBranchDataAdapter source, NodeBranchDataAdapter dest, boolean includeLeaves) {
        super(document, dest);
        this.source = source;
        this.includeLeaves = includeLeaves;
    }

    private void copySubtree(Node root) {
        if (this.includeLeaves || !root.isLeaf()) {
            if (this.source.isDecimal(root)) {
                this.getAdapter().setDecimal(root, this.source.getDecimal(root));
            } else if (this.source.isString(root)) {
                try {
                    this.getAdapter().setText(root, this.source.getText(root));
                }
                catch (NumberFormatException e) {
                    this.getAdapter().setDecimal(root, Double.NaN);
                }
            } else {
                this.getAdapter().delete(root);
            }
            int i = 0;
            while (i < root.getChildren().size()) {
                this.copySubtree(root.getChildren().get(i));
                ++i;
            }
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.copySubtree(this.getDocument().getTree().getPaintStart());
        super.redo();
    }

    @Override
    public String getPresentationName() {
        return "Copy column \"" + this.source.toString() + "\" to \"" + this.getAdapter().toString() + "\"";
    }
}

