/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.ComposedDocumentEdit;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import info.bioinfweb.treegraph.document.undo.WarningMessageEdit;
import info.bioinfweb.treegraph.document.undo.edit.CollapseNodeEdit;
import java.util.Iterator;
import javax.swing.undo.CannotRedoException;

public class CollapseNodesBySupportEdit
extends ComposedDocumentEdit
implements WarningMessageEdit {
    private NodeBranchDataAdapter supportAdapter;
    private double threshold = -1.0;
    private boolean legendsReanchored = false;
    private boolean nodeBranchDataMissing = false;
    private boolean nodeBranchDataInvalid = false;

    public CollapseNodesBySupportEdit(Document document, Node root, NodeBranchDataAdapter supportAdapter, double threshold) {
        super(document, DocumentChangeType.TOPOLOGICAL_LEAF_INVARIANT);
        this.supportAdapter = supportAdapter;
        this.threshold = threshold;
        this.createSubedits(root);
    }

    public boolean getLegendsReanchored() {
        return this.legendsReanchored;
    }

    public boolean getNodeBranchDataMissing() {
        return this.nodeBranchDataMissing;
    }

    public boolean getNodeBranchDataInvalid() {
        return this.nodeBranchDataInvalid;
    }

    private void createSubedits(Node root) {
        if (!root.isLeaf()) {
            if (this.supportAdapter.isEmpty(root)) {
                this.nodeBranchDataMissing = true;
            } else if (!this.supportAdapter.isDecimal(root)) {
                this.nodeBranchDataInvalid = true;
            } else if (this.supportAdapter.getDecimal(root) < this.threshold) {
                CollapseNodeEdit edit = new CollapseNodeEdit(this.getDocument(), root);
                edit.setIsSubedit(true);
                this.getEdits().add(edit);
            }
            for (Node child : root.getChildren()) {
                this.createSubedits(child);
            }
        }
    }

    private void checkEditsForWarnings() {
        Iterator<DocumentEdit> iterator = this.getEdits().iterator();
        while (iterator.hasNext() && !this.legendsReanchored) {
            boolean bl = this.legendsReanchored = this.legendsReanchored || ((CollapseNodeEdit)iterator.next()).getLegendsReanchored();
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.checkEditsForWarnings();
    }

    @Override
    public String getPresentationName() {
        return "Collapse nodes in subtree with support in " + this.supportAdapter + " below " + this.threshold;
    }

    @Override
    public String getWarningText() {
        String msg = "";
        if (this.getNodeBranchDataInvalid()) {
            msg = String.valueOf(msg) + "- One or more node(s) in the affected subtree did contain non-numerical values in the specified node/branch data column. (Make sure that all relevant values are marked as decimal values and not as strings.)\n";
        }
        if (this.getNodeBranchDataMissing()) {
            msg = String.valueOf(msg) + "- One or more node(s) in the affected subtree did not carry any value in the specified node/branch data column.\n";
        }
        if (this.getLegendsReanchored()) {
            msg = String.valueOf(msg) + "- One or more legend(s) that were anchored inside the affected subtree were reanchored.\n";
        }
        if ("".equals(msg)) {
            return null;
        }
        return "This process produced warnings:\n\n" + msg + "\nYou can use the undo-function to restore lost or changed data.";
    }

    @Override
    public boolean hasWarnings() {
        return this.getNodeBranchDataMissing() || this.getNodeBranchDataInvalid() || this.getLegendsReanchored();
    }
}

